/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine;

import com.google.common.collect.BiMap;
import dev.ftb.mods.ftbultimine.BrokenItemHandler;
import dev.ftb.mods.ftbultimine.FTBUltimine;
import dev.ftb.mods.ftbultimine.FTBUltiminePlayerData;
import dev.ftb.mods.ftbultimine.ItemCollection;
import dev.ftb.mods.ftbultimine.config.FTBUltimineServerConfig;
import dev.ftb.mods.ftbultimine.mixin.AxeItemAccess;
import dev.ftb.mods.ftbultimine.mixin.ShovelItemAccess;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class RightClickHandlers {
    static boolean axeStripping(ServerPlayer player, InteractionHand hand, BlockPos clickPos, FTBUltiminePlayerData data) {
        HashSet<SoundEvent> sounds = new HashSet<SoundEvent>();
        BrokenItemHandler brokenItemHandler = new BrokenItemHandler();
        Level level = player.m_9236_();
        ItemStack itemStack = player.m_21120_(hand);
        AxeItemAccess axeItemAccess = (AxeItemAccess)itemStack.m_41720_();
        for (BlockPos pos : data.cachedPositions()) {
            BlockState state = player.m_9236_().m_8055_(pos);
            Optional<BlockState> stripping = axeItemAccess.invokeGetStripped(state);
            Optional scraping = WeatheringCopper.m_154899_((BlockState)state);
            Optional<BlockState> waxing = Optional.ofNullable((Block)((BiMap)HoneycombItem.f_150864_.get()).get((Object)state.m_60734_())).map(block -> block.m_152465_(state));
            Optional<Object> actual = Optional.empty();
            if (stripping.isPresent()) {
                sounds.add(SoundEvents.f_11688_);
                actual = stripping;
            } else if (scraping.isPresent()) {
                sounds.add(SoundEvents.f_144059_);
                level.m_5898_((Player)player, 3005, pos, 0);
                actual = scraping;
            } else if (waxing.isPresent()) {
                sounds.add(SoundEvents.f_144060_);
                level.m_5898_((Player)player, 3004, pos, 0);
                actual = waxing;
            }
            if (!actual.isPresent()) continue;
            CriteriaTriggers.f_10562_.m_285767_(player, pos, itemStack);
            level.m_7731_(pos, (BlockState)actual.get(), 11);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)((BlockState)actual.get())));
            itemStack.m_41622_(1, (LivingEntity)player, (Consumer)brokenItemHandler);
            if (!brokenItemHandler.isBroken) continue;
            break;
        }
        sounds.forEach(sound -> level.m_5594_(null, clickPos, sound, SoundSource.BLOCKS, 1.0f, 1.0f));
        return !sounds.isEmpty();
    }

    static boolean shovelFlattening(ServerPlayer player, InteractionHand hand, BlockPos clickPos, FTBUltiminePlayerData data) {
        boolean didWork = false;
        BrokenItemHandler brokenItemHandler = new BrokenItemHandler();
        for (BlockPos pos : data.cachedPositions()) {
            if (!player.m_9236_().m_8055_(pos.m_7494_()).m_60795_()) continue;
            BlockState state = player.m_9236_().m_8055_(pos);
            BlockState newState = ShovelItemAccess.getFlattenables().get(state.m_60734_());
            if (newState == null && state.m_204336_(FTBUltimine.FLATTENABLE_TAG)) {
                newState = Blocks.f_152481_.m_49966_();
            }
            if (newState == null) continue;
            player.m_9236_().m_7731_(pos, newState, 11);
            didWork = true;
            player.m_21205_().m_41622_(1, (LivingEntity)player, (Consumer)brokenItemHandler);
            player.m_9236_().m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)newState));
            if (!brokenItemHandler.isBroken && player.m_36324_().m_38702_() > 0) continue;
            break;
        }
        if (didWork) {
            player.m_9236_().m_5594_((Player)player, clickPos, SoundEvents.f_12406_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    static boolean farmlandConversion(ServerPlayer player, InteractionHand hand, BlockPos clickPos, FTBUltiminePlayerData data) {
        boolean didWork = false;
        BrokenItemHandler brokenItemHandler = new BrokenItemHandler();
        for (BlockPos pos : data.cachedPositions()) {
            BlockState state;
            if (!player.m_9236_().m_8055_(pos.m_7494_()).m_60795_() || !(state = player.m_9236_().m_8055_(pos)).m_204336_(FTBUltimine.TILLABLE_TAG)) continue;
            player.m_9236_().m_7731_(pos, Blocks.f_50093_.m_49966_(), 11);
            player.m_9236_().m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)Blocks.f_50093_.m_49966_()));
            didWork = true;
            if (player.m_7500_()) continue;
            player.m_36399_((float)((Double)FTBUltimineServerConfig.EXHAUSTION_PER_BLOCK.get() * 0.005));
            player.m_21205_().m_41622_(1, (LivingEntity)player, (Consumer)brokenItemHandler);
            if (!brokenItemHandler.isBroken && !FTBUltimine.isTooExhausted(player)) continue;
            break;
        }
        if (didWork) {
            player.m_9236_().m_5594_((Player)player, clickPos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    static boolean cropHarvesting(ServerPlayer player, InteractionHand hand, BlockPos clickPos, Direction face, FTBUltiminePlayerData data) {
        boolean didWork = false;
        ItemCollection itemCollection = new ItemCollection();
        for (BlockPos pos : data.cachedPositions()) {
            BlockState state = player.m_9236_().m_8055_(pos);
            if (!RightClickHandlers.isHarvestable(state)) continue;
            BlockEntity blockEntity = state.m_155947_() ? player.m_9236_().m_7702_(pos) : null;
            List drops = Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)player.m_9236_()), (BlockPos)pos, (BlockEntity)blockEntity, (Entity)player, (ItemStack)ItemStack.f_41583_);
            for (ItemStack stack : drops) {
                if (Block.m_49814_((Item)stack.m_41720_()) == state.m_60734_() && RightClickHandlers.consumesItemToReplant(state)) {
                    stack.m_41774_(1);
                }
                itemCollection.add(stack);
            }
            RightClickHandlers.resetAge(player.m_9236_(), pos, state);
            didWork = true;
        }
        itemCollection.drop(player.m_9236_(), face == null ? clickPos : clickPos.m_121945_(face));
        return didWork;
    }

    private static boolean consumesItemToReplant(BlockState state) {
        return state.m_60734_() != Blocks.f_50685_;
    }

    private static boolean isHarvestable(BlockState state) {
        CropBlock cropBlock;
        Block block = state.m_60734_();
        return block instanceof CropBlock && (cropBlock = (CropBlock)block).m_52307_(state) || state.m_60734_() instanceof SweetBerryBushBlock && (Integer)state.m_61143_((Property)SweetBerryBushBlock.f_57244_) >= 3 || state.m_60734_() instanceof CocoaBlock && (Integer)state.m_61143_((Property)CocoaBlock.f_51736_) >= 2;
    }

    private static void resetAge(Level level, BlockPos pos, BlockState currentState) {
        Block block = currentState.m_60734_();
        if (block instanceof CropBlock) {
            CropBlock cropBlock = (CropBlock)block;
            level.m_7731_(pos, cropBlock.m_52289_(0), 3);
        } else if (currentState.m_60734_() instanceof SweetBerryBushBlock) {
            level.m_7731_(pos, (BlockState)currentState.m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(1)), 3);
        } else if (currentState.m_60734_() instanceof CocoaBlock) {
            level.m_7731_(pos, (BlockState)currentState.m_61124_((Property)CocoaBlock.f_51736_, (Comparable)Integer.valueOf(0)), 3);
        }
    }
}

