/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.api.property;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbteams.api.property.TeamProperty;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyType;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyValue;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class StringProperty
extends TeamProperty<String> {
    private final Pattern pattern;

    public StringProperty(ResourceLocation id, String def, @Nullable Pattern p) {
        super(id, def);
        this.pattern = p;
    }

    public StringProperty(ResourceLocation id, String def) {
        this(id, def, null);
    }

    public StringProperty(ResourceLocation id, FriendlyByteBuf buf) {
        super(id, buf.m_130136_(Short.MAX_VALUE));
        int f = buf.m_130242_();
        String s = buf.m_130136_(Short.MAX_VALUE);
        this.pattern = s.isEmpty() ? null : Pattern.compile(s, f);
    }

    @Override
    public TeamPropertyType<String> getType() {
        return TeamPropertyType.STRING;
    }

    @Override
    public Optional<String> fromString(String string) {
        if (this.pattern == null || this.pattern.matcher(string).matches()) {
            return Optional.of(string);
        }
        return Optional.empty();
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130072_((String)this.defaultValue, Short.MAX_VALUE);
        buf.m_130130_(this.pattern == null ? 0 : this.pattern.flags());
        buf.m_130072_(this.pattern == null ? "" : this.pattern.pattern(), Short.MAX_VALUE);
    }

    @Override
    public void config(ConfigGroup config, TeamPropertyValue<String> value) {
        config.addString(this.id.m_135815_(), (String)value.value, value.consumer, (String)this.defaultValue, this.pattern);
    }
}

