/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CommandReward
extends Reward {
    private String command = "/say Hi, @p!";
    private boolean elevatePerms;
    private boolean silent;

    public CommandReward(long id, Quest quest) {
        super(id, quest);
    }

    @Override
    public RewardType getType() {
        return RewardTypes.COMMAND;
    }

    @Override
    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128359_("command", this.command);
        if (this.elevatePerms) {
            nbt.m_128379_("elevate_perms", true);
        }
        if (this.silent) {
            nbt.m_128379_("silent", true);
        }
    }

    @Override
    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.command = nbt.m_128461_("command");
        this.elevatePerms = nbt.m_128471_("elevate_perms");
        this.silent = nbt.m_128471_("silent");
    }

    @Override
    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130072_(this.command, Short.MAX_VALUE);
        buffer.writeBoolean(this.elevatePerms);
        buffer.writeBoolean(this.silent);
    }

    @Override
    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.command = buffer.m_130136_(Short.MAX_VALUE);
        this.elevatePerms = buffer.readBoolean();
        this.silent = buffer.readBoolean();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addString("command", this.command, v -> {
            this.command = v;
        }, "/say Hi, @team!").setNameKey("ftbquests.reward.ftbquests.command");
        config.addBool("elevate", this.elevatePerms, v -> {
            this.elevatePerms = v;
        }, false);
        config.addBool("silent", this.silent, v -> {
            this.silent = v;
        }, false);
    }

    @Override
    public void claim(ServerPlayer player, boolean notify) {
        HashMap<String, Object> overrides = new HashMap<String, Object>();
        overrides.put("p", player.m_36316_().getName());
        BlockPos pos = player.m_20183_();
        overrides.put("x", pos.m_123341_());
        overrides.put("y", pos.m_123342_());
        overrides.put("z", pos.m_123343_());
        if (this.getQuestChapter() != null) {
            overrides.put("chapter", this.getQuestChapter());
        }
        overrides.put("quest", this.quest);
        String cmd = this.command;
        for (Map.Entry entry : overrides.entrySet()) {
            if (entry.getValue() == null) continue;
            cmd = cmd.replace("{" + (String)entry.getKey() + "}", entry.getValue().toString());
        }
        CommandSourceStack source = player.m_20203_();
        if (this.elevatePerms) {
            source = source.m_81325_(2);
        }
        if (this.silent) {
            source = source.m_81324_();
        }
        player.f_8924_.m_129892_().m_230957_(source, cmd);
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getAltTitle() {
        return Component.m_237115_((String)"ftbquests.reward.ftbquests.command").m_130946_(": ").m_7220_((Component)Component.m_237113_((String)this.command).m_130940_(ChatFormatting.RED));
    }
}

