/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.LongConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigFromStringScreen;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.task.ISingleLongValueTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public final class TaskType {
    private final ResourceLocation typeId;
    private final Provider provider;
    private final Supplier<Icon> iconSupplier;
    private Component displayName;
    private GuiProvider guiProvider;
    public int internalId;

    TaskType(ResourceLocation typeId, Provider provider, Supplier<Icon> iconSupplier) {
        this.typeId = typeId;
        this.provider = provider;
        this.iconSupplier = iconSupplier;
        this.displayName = null;
        this.guiProvider = (gui, quest, callback) -> {
            Task task = this.provider.create(0L, quest);
            if (task instanceof ISingleLongValueTask) {
                ISingleLongValueTask slvTask = (ISingleLongValueTask)((Object)task);
                LongConfig c = new LongConfig(slvTask.getMinConfigValue(), slvTask.getMaxConfigValue());
                EditConfigFromStringScreen.open((ConfigFromString)c, (Object)slvTask.getDefaultConfigValue(), (Object)slvTask.getDefaultConfigValue(), accepted -> {
                    if (accepted) {
                        slvTask.setValue((Long)c.getValue());
                        callback.accept(task);
                    }
                    gui.run();
                });
            } else {
                ConfigGroup group = new ConfigGroup("ftbquests", accepted -> {
                    if (accepted) {
                        callback.accept(task);
                    }
                    gui.run();
                });
                task.fillConfigGroup(task.createSubGroup(group));
                new EditConfigScreen(group).openGui();
            }
        };
    }

    public ResourceLocation getTypeId() {
        return this.typeId;
    }

    @Nullable
    public static Task createTask(long id, Quest quest, String typeId) {
        if (((String)typeId).isEmpty()) {
            typeId = "ftbquests:item";
        } else if (((String)typeId).indexOf(58) == -1) {
            typeId = "ftbquests:" + (String)typeId;
        }
        TaskType type = TaskTypes.TYPES.get(new ResourceLocation((String)typeId));
        if (type == null) {
            return null;
        }
        return type.provider.create(id, quest);
    }

    public Task createTask(long id, Quest quest) {
        return this.provider.create(id, quest);
    }

    public String getTypeForNBT() {
        return this.typeId.m_135827_().equals("ftbquests") ? this.typeId.m_135815_() : this.typeId.toString();
    }

    public TaskType setDisplayName(Component name) {
        this.displayName = name;
        return this;
    }

    public Component getDisplayName() {
        if (this.displayName == null) {
            this.displayName = Component.m_237115_((String)("ftbquests.task." + this.typeId.m_135827_() + "." + this.typeId.m_135815_()));
        }
        return this.displayName;
    }

    public Icon getIconSupplier() {
        return this.iconSupplier.get();
    }

    public TaskType setGuiProvider(GuiProvider p) {
        this.guiProvider = p;
        return this;
    }

    public GuiProvider getGuiProvider() {
        return this.guiProvider;
    }

    @FunctionalInterface
    public static interface Provider {
        public Task create(long var1, Quest var3);
    }

    @FunctionalInterface
    public static interface GuiProvider {
        @OnlyIn(value=Dist.CLIENT)
        public void openCreationGui(Runnable var1, Quest var2, Consumer<Task> var3);
    }
}

