/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client;

import com.mojang.blaze3d.platform.InputConstants;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.fluid.FluidStack;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.FluidConfig;
import dev.ftb.mods.ftblibrary.config.ImageConfig;
import dev.ftb.mods.ftblibrary.config.IntConfig;
import dev.ftb.mods.ftblibrary.config.ItemStackConfig;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigFromStringScreen;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.config.ui.SelectFluidScreen;
import dev.ftb.mods.ftblibrary.config.ui.SelectItemStackScreen;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.block.FTBQuestsBlocks;
import dev.ftb.mods.ftbquests.block.entity.TaskScreenBlockEntity;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.FTBQuestsClientEventHandler;
import dev.ftb.mods.ftbquests.client.QuestFileCacheReloader;
import dev.ftb.mods.ftbquests.item.FTBQuestsItems;
import dev.ftb.mods.ftbquests.net.SetCustomImageMessage;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.reward.ItemReward;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import dev.ftb.mods.ftbquests.quest.reward.XPLevelsReward;
import dev.ftb.mods.ftbquests.quest.reward.XPReward;
import dev.ftb.mods.ftbquests.quest.task.CheckmarkTask;
import dev.ftb.mods.ftbquests.quest.task.DimensionTask;
import dev.ftb.mods.ftbquests.quest.task.FluidTask;
import dev.ftb.mods.ftbquests.quest.task.ItemTask;
import dev.ftb.mods.ftbquests.quest.task.LocationTask;
import dev.ftb.mods.ftbquests.quest.task.ObservationTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import dev.ftb.mods.ftbquests.quest.theme.ThemeLoader;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class FTBQuestsClient {
    public static KeyMapping KEY_QUESTS;

    public static void init() {
        ClientLifecycleEvent.CLIENT_SETUP.register(FTBQuestsClient::onClientSetup);
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)new QuestFileCacheReloader());
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)new ThemeLoader());
        KEY_QUESTS = new KeyMapping("key.ftbquests.quests", InputConstants.Type.KEYSYM, -1, "key.categories.ftbquests");
        KeyMappingRegistry.register((KeyMapping)KEY_QUESTS);
        new FTBQuestsClientEventHandler().init();
    }

    private static void onClientSetup(Minecraft minecraft) {
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)FTBQuestsBlocks.BARRIER.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)FTBQuestsBlocks.STAGE_BARRIER.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110451_(), (Block[])new Block[]{(Block)FTBQuestsBlocks.TASK_SCREEN_1.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110451_(), (Block[])new Block[]{(Block)FTBQuestsBlocks.TASK_SCREEN_3.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110451_(), (Block[])new Block[]{(Block)FTBQuestsBlocks.TASK_SCREEN_5.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110451_(), (Block[])new Block[]{(Block)FTBQuestsBlocks.TASK_SCREEN_7.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110451_(), (Block[])new Block[]{(Block)FTBQuestsBlocks.AUX_SCREEN.get()});
        FTBQuestsClient.setTaskGuiProviders();
        FTBQuestsClient.setRewardGuiProviders();
    }

    @Nullable
    public static BaseQuestFile getClientQuestFile() {
        return ClientQuestFile.INSTANCE;
    }

    public static void setTaskGuiProviders() {
        TaskTypes.ITEM.setGuiProvider((gui, quest, callback) -> {
            ItemStackConfig c = new ItemStackConfig(false, false);
            new SelectItemStackScreen(c, accepted -> {
                gui.run();
                if (accepted) {
                    ItemTask itemTask = new ItemTask(0L, quest).setStackAndCount((ItemStack)c.getValue(), ((ItemStack)c.getValue()).m_41613_());
                    callback.accept(itemTask);
                }
            }).openGui();
        });
        TaskTypes.CHECKMARK.setGuiProvider((gui, quest, callback) -> {
            StringConfig c = new StringConfig(null);
            EditConfigFromStringScreen.open((ConfigFromString)c, (Object)"", (Object)"", accepted -> {
                if (accepted) {
                    CheckmarkTask checkmarkTask = new CheckmarkTask(0L, quest);
                    checkmarkTask.setRawTitle((String)c.getValue());
                    callback.accept(checkmarkTask);
                }
                gui.run();
            });
        });
        TaskTypes.FLUID.setGuiProvider((gui, quest, callback) -> {
            FluidConfig c = new FluidConfig(false);
            new SelectFluidScreen(c, accepted -> {
                gui.run();
                if (accepted) {
                    FluidTask fluidTask = new FluidTask(0L, quest).setFluid(((FluidStack)c.getValue()).getFluid());
                    callback.accept(fluidTask);
                }
            }).openGui();
        });
        TaskTypes.DIMENSION.setGuiProvider((gui, quest, callback) -> {
            DimensionTask task = new DimensionTask(0L, quest).withDimension((ResourceKey<Level>)Minecraft.m_91087_().f_91073_.m_46472_());
            FTBQuestsClient.openSetupGui(gui, callback, task);
        });
        TaskTypes.OBSERVATION.setGuiProvider((gui, quest, callback) -> {
            ObservationTask task = new ObservationTask(0L, quest);
            HitResult patt5604$temp = Minecraft.m_91087_().f_91077_;
            if (patt5604$temp instanceof BlockHitResult) {
                BlockHitResult bhr = (BlockHitResult)patt5604$temp;
                Block block = Minecraft.m_91087_().f_91073_.m_8055_(bhr.m_82425_()).m_60734_();
                task.setToObserve(BuiltInRegistries.f_256975_.m_7981_((Object)block).toString());
            }
            FTBQuestsClient.openSetupGui(gui, callback, task);
        });
        TaskTypes.LOCATION.setGuiProvider((gui, quest, callback) -> {
            BlockHitResult bhr;
            BlockEntity blockEntity;
            LocationTask task = new LocationTask(0L, quest);
            Minecraft mc = Minecraft.m_91087_();
            HitResult patt6033$temp = mc.f_91077_;
            if (patt6033$temp instanceof BlockHitResult && (blockEntity = mc.f_91073_.m_7702_((bhr = (BlockHitResult)patt6033$temp).m_82425_())) instanceof StructureBlockEntity) {
                StructureBlockEntity structure = (StructureBlockEntity)blockEntity;
                task.initFromStructure(structure);
                callback.accept(task);
                return;
            }
            FTBQuestsClient.openSetupGui(gui, callback, task);
        });
    }

    private static void openSetupGui(Runnable gui, Consumer<Task> callback, Task task) {
        ConfigGroup group = new ConfigGroup("ftbquests", accepted -> {
            gui.run();
            if (accepted) {
                callback.accept(task);
            }
        });
        task.fillConfigGroup(task.createSubGroup(group));
        new EditConfigScreen(group).openGui();
    }

    public static void setRewardGuiProviders() {
        RewardTypes.ITEM.setGuiProvider((gui, quest, callback) -> {
            ItemStackConfig c = new ItemStackConfig(false, false);
            new SelectItemStackScreen(c, accepted -> {
                if (accepted) {
                    ItemStack copy = ((ItemStack)c.getValue()).m_41777_();
                    copy.m_41764_(1);
                    ItemReward reward = new ItemReward(0L, quest, copy, ((ItemStack)c.getValue()).m_41613_());
                    callback.accept(reward);
                }
                gui.run();
            }).openGui();
        });
        RewardTypes.XP.setGuiProvider((gui, quest, callback) -> {
            IntConfig c = new IntConfig(1, Integer.MAX_VALUE);
            EditConfigFromStringScreen.open((ConfigFromString)c, (Object)100, (Object)100, accepted -> {
                if (accepted) {
                    callback.accept(new XPReward(0L, quest, (Integer)c.getValue()));
                }
                gui.run();
            });
        });
        RewardTypes.XP_LEVELS.setGuiProvider((gui, quest, callback) -> {
            IntConfig c = new IntConfig(1, Integer.MAX_VALUE);
            EditConfigFromStringScreen.open((ConfigFromString)c, (Object)5, (Object)5, accepted -> {
                if (accepted) {
                    callback.accept(new XPLevelsReward(0L, quest, (Integer)c.getValue()));
                }
                gui.run();
            });
        });
    }

    public static Player getClientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    public static Level getClientLevel() {
        return Minecraft.m_91087_().f_91073_;
    }

    public static boolean isClientDataLoaded() {
        return ClientQuestFile.exists();
    }

    public static TeamData getClientPlayerData() {
        return ClientQuestFile.INSTANCE.selfTeamData;
    }

    public static BaseQuestFile createClientQuestFile() {
        return new ClientQuestFile();
    }

    public static void openGui() {
        ClientQuestFile.openGui();
    }

    public static void openCustomIconGui(Player player, InteractionHand hand) {
        ImageConfig config = new ImageConfig();
        config.onClicked(MouseButton.LEFT, b -> {
            if (b) {
                if (((String)config.getValue()).isEmpty()) {
                    player.m_21120_(hand).m_41749_("Icon");
                } else {
                    player.m_21120_(hand).m_41700_("Icon", (Tag)StringTag.m_129297_((String)((String)config.getValue())));
                }
                new SetCustomImageMessage(hand, (String)config.getValue()).sendToServer();
            }
            Minecraft.m_91087_().m_91152_(null);
        });
    }

    public static void openScreenConfigGui(BlockPos pos) {
        BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(pos);
        if (blockEntity instanceof TaskScreenBlockEntity) {
            TaskScreenBlockEntity coreScreen = (TaskScreenBlockEntity)blockEntity;
            new EditConfigScreen(coreScreen.fillConfigGroup(ClientQuestFile.INSTANCE.getOrCreateTeamData(coreScreen.getTeamId()))).setAutoclose(true).openGui();
        }
    }

    public static float[] getTextureUV(BlockState state, Direction face) {
        if (state == null) {
            return null;
        }
        BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(state);
        List quads = model.m_213637_(state, face, RandomSource.m_216327_());
        if (!quads.isEmpty()) {
            TextureAtlasSprite sprite = ((BakedQuad)quads.get(0)).m_173410_();
            return new float[]{sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_()};
        }
        return new float[0];
    }

    public static void rebuildCreativeTabs() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            FTBQuests.LOGGER.debug("deferring creative tab rebuild, client player still null");
            FTBQuestsClientEventHandler.creativeTabRebuildPending = true;
        } else {
            FTBQuests.LOGGER.debug("rebuilding creative tabs now");
            CreativeModeTab.ItemDisplayParameters params = new CreativeModeTab.ItemDisplayParameters(player.f_108617_.m_247016_(), player.m_36337_(), (HolderLookup.Provider)player.m_9236_().m_9598_());
            ((CreativeModeTab)FTBQuestsItems.CREATIVE_TAB.get()).m_269498_(params);
            CreativeModeTabs.m_258007_().m_269498_(params);
        }
    }

    public static Optional<RegistryAccess> registryAccess() {
        return Minecraft.m_91087_().f_91073_ == null ? Optional.empty() : Optional.of(Minecraft.m_91087_().f_91073_.m_9598_());
    }
}

