/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

public class TooltipList {
    private final List<Component> lines = new ArrayList<Component>();
    public int zOffset = 950;
    public int zOffsetItemTooltip = 0;
    public int backgroundColor = -267386864;
    public int borderColorStart = 0x505000FF;
    public int borderColorEnd = (this.borderColorStart & 0xFEFEFE) >> 1 | this.borderColorStart & 0xFF000000;
    public int maxWidth = 0;
    public int xOffset = 0;
    public int yOffset = 0;

    public boolean shouldRender() {
        return !this.lines.isEmpty();
    }

    public void reset() {
        this.lines.clear();
        this.zOffset = 950;
        this.zOffsetItemTooltip = 0;
        this.backgroundColor = -267386864;
        this.borderColorStart = 0x505000FF;
        this.borderColorEnd = (this.borderColorStart & 0xFEFEFE) >> 1 | this.borderColorStart & 0xFF000000;
        this.maxWidth = 0;
        this.xOffset = 0;
        this.yOffset = 0;
    }

    public void add(Component component) {
        this.lines.add(component);
    }

    public void blankLine() {
        this.add((Component)Component.m_237119_());
    }

    public void styledString(String text, Style style) {
        this.add((Component)Component.m_237113_((String)text).m_130948_(style));
    }

    public void styledString(String text, ChatFormatting color) {
        this.add((Component)Component.m_237113_((String)text).m_130940_(color));
    }

    public void styledTranslate(String key, Style style, Object ... objects) {
        this.add((Component)Component.m_237110_((String)key, (Object[])objects).m_130948_(style));
    }

    public void string(String text) {
        this.styledString(text, Style.f_131099_);
    }

    public void translate(String key, Object ... objects) {
        this.styledTranslate(key, Style.f_131099_, objects);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics graphics, int mouseX, int mouseY, int screenWidth, int screenHeight, Font font) {
        boolean bl;
        mouseX += this.xOffset;
        mouseY += this.yOffset;
        ArrayList<FormattedCharSequence> textLines = new ArrayList<FormattedCharSequence>(this.lines.size());
        for (Component component : this.lines) {
            textLines.add(component.m_7532_());
        }
        RenderSystem.disableDepthTest();
        int tooltipTextWidth = 0;
        for (FormattedCharSequence textLine : textLines) {
            int textLineWidth = font.m_92724_(textLine);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        boolean bl2 = false;
        int titleLinesCount = 1;
        int tooltipX = mouseX + 12;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
            boolean bl3 = true;
        }
        if (this.maxWidth > 0 && tooltipTextWidth > this.maxWidth) {
            tooltipTextWidth = this.maxWidth;
            bl = true;
        }
        if (bl) {
            int wrappedTooltipWidth = 0;
            ArrayList<FormattedCharSequence> wrappedTextLines = new ArrayList<FormattedCharSequence>();
            for (int i = 0; i < this.lines.size(); ++i) {
                Component textLine = this.lines.get(i);
                List wrappedLine = font.m_92923_((FormattedText)textLine, tooltipTextWidth);
                if (i == 0) {
                    titleLinesCount = wrappedLine.size();
                }
                for (FormattedCharSequence line : wrappedLine) {
                    int lineWidth = font.m_92724_(line);
                    if (lineWidth > wrappedTooltipWidth) {
                        wrappedTooltipWidth = lineWidth;
                    }
                    wrappedTextLines.add(line);
                }
            }
            tooltipTextWidth = wrappedTooltipWidth;
            textLines = wrappedTextLines;
            tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
        }
        int tooltipY = mouseY - 12;
        int tooltipHeight = 8;
        if (textLines.size() > 1) {
            tooltipHeight += (textLines.size() - 1) * 10;
            if (textLines.size() > titleLinesCount) {
                tooltipHeight += 2;
            }
        }
        if (tooltipY < 4) {
            tooltipY = 4;
        } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
            tooltipY = screenHeight - tooltipHeight - 4;
        }
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, (float)this.zOffset);
        Matrix4f mat = poseStack.m_85850_().m_252922_();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        TooltipList.drawGradientRect(mat, buffer, tooltipX - 3, tooltipY - 4, tooltipX + tooltipTextWidth + 3, tooltipY - 3, this.backgroundColor, this.backgroundColor);
        TooltipList.drawGradientRect(mat, buffer, tooltipX - 3, tooltipY + tooltipHeight + 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 4, this.backgroundColor, this.backgroundColor);
        TooltipList.drawGradientRect(mat, buffer, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, this.backgroundColor, this.backgroundColor);
        TooltipList.drawGradientRect(mat, buffer, tooltipX - 4, tooltipY - 3, tooltipX - 3, tooltipY + tooltipHeight + 3, this.backgroundColor, this.backgroundColor);
        TooltipList.drawGradientRect(mat, buffer, tooltipX + tooltipTextWidth + 3, tooltipY - 3, tooltipX + tooltipTextWidth + 4, tooltipY + tooltipHeight + 3, this.backgroundColor, this.backgroundColor);
        TooltipList.drawGradientRect(mat, buffer, tooltipX - 3, tooltipY - 3 + 1, tooltipX - 3 + 1, tooltipY + tooltipHeight + 3 - 1, this.borderColorStart, this.borderColorEnd);
        TooltipList.drawGradientRect(mat, buffer, tooltipX + tooltipTextWidth + 2, tooltipY - 3 + 1, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3 - 1, this.borderColorStart, this.borderColorEnd);
        TooltipList.drawGradientRect(mat, buffer, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY - 3 + 1, this.borderColorStart, this.borderColorStart);
        TooltipList.drawGradientRect(mat, buffer, tooltipX - 3, tooltipY + tooltipHeight + 2, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, this.borderColorEnd, this.borderColorEnd);
        tesselator.m_85914_();
        RenderSystem.disableBlend();
        MultiBufferSource.BufferSource renderType = MultiBufferSource.m_109898_((BufferBuilder)buffer);
        for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
            FormattedCharSequence line = (FormattedCharSequence)textLines.get(lineNumber);
            if (line != null) {
                font.m_272191_(line, (float)tooltipX, (float)tooltipY, -1, true, mat, (MultiBufferSource)renderType, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            }
            if (lineNumber + 1 == titleLinesCount) {
                tooltipY += 2;
            }
            tooltipY += 10;
        }
        renderType.m_109911_();
        poseStack.m_85849_();
        RenderSystem.enableDepthTest();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawGradientRect(Matrix4f mat, BufferBuilder buffer, int left, int top, int right, int bottom, int startColor, int endColor) {
        int startAlpha = startColor >> 24 & 0xFF;
        int startRed = startColor >> 16 & 0xFF;
        int startGreen = startColor >> 8 & 0xFF;
        int startBlue = startColor & 0xFF;
        int endAlpha = endColor >> 24 & 0xFF;
        int endRed = endColor >> 16 & 0xFF;
        int endGreen = endColor >> 8 & 0xFF;
        int endBlue = endColor & 0xFF;
        buffer.m_252986_(mat, (float)right, (float)top, 0.0f).m_6122_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        buffer.m_252986_(mat, (float)left, (float)top, 0.0f).m_6122_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        buffer.m_252986_(mat, (float)left, (float)bottom, 0.0f).m_6122_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        buffer.m_252986_(mat, (float)right, (float)bottom, 0.0f).m_6122_(endRed, endGreen, endBlue, endAlpha).m_5752_();
    }
}

