/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbchunks.api.ClaimedChunk;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.client.map.MapChunk;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SendChunkPacket
extends BaseS2CMessage {
    public final ResourceKey<Level> dimension;
    public final UUID teamId;
    public final SingleChunk chunk;

    public SendChunkPacket(ResourceKey<Level> dimension, UUID teamId, SingleChunk chunk) {
        this.dimension = dimension;
        this.teamId = teamId;
        this.chunk = chunk;
    }

    SendChunkPacket(FriendlyByteBuf buf) {
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)buf.m_130281_());
        this.teamId = buf.m_130259_();
        this.chunk = new SingleChunk(buf, this.teamId);
    }

    public MessageType getType() {
        return FTBChunksNet.SEND_CHUNK;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130085_(this.dimension.m_135782_());
        buf.m_130077_(this.teamId);
        this.chunk.write(buf, this.teamId);
    }

    public void handle(NetworkManager.PacketContext context) {
        FTBChunksClient.INSTANCE.updateChunksFromServer(this.dimension, this.teamId, List.of(this.chunk));
    }

    public static class SingleChunk {
        private final int x;
        private final int z;
        private final long relativeTimeClaimed;
        private final boolean forceLoaded;
        private final long relativeTimeForceLoaded;
        private final boolean expires;
        private final long relativeForceLoadExpiryTime;

        public SingleChunk(long now, int x, int z, @Nullable ClaimedChunk claimedChunk) {
            this.x = x;
            this.z = z;
            if (claimedChunk != null) {
                this.relativeTimeClaimed = now - claimedChunk.getTimeClaimed();
                this.forceLoaded = claimedChunk.isForceLoaded();
                this.expires = claimedChunk.getForceLoadExpiryTime() > 0L;
                this.relativeTimeForceLoaded = this.forceLoaded ? now - claimedChunk.getForceLoadedTime() : 0L;
                this.relativeForceLoadExpiryTime = this.expires ? claimedChunk.getForceLoadExpiryTime() - now : 0L;
            } else {
                this.relativeForceLoadExpiryTime = 0L;
                this.relativeTimeForceLoaded = 0L;
                this.relativeTimeClaimed = 0L;
                this.expires = false;
                this.forceLoaded = false;
            }
        }

        public int getX() {
            return this.x;
        }

        public int getZ() {
            return this.z;
        }

        public SingleChunk(FriendlyByteBuf buf, UUID teamId) {
            this.x = buf.m_130242_();
            this.z = buf.m_130242_();
            if (!teamId.equals(Util.f_137441_)) {
                this.relativeTimeClaimed = buf.m_130258_();
                this.forceLoaded = buf.readBoolean();
                this.expires = buf.readBoolean();
                this.relativeTimeForceLoaded = this.forceLoaded ? buf.m_130258_() : 0L;
                this.relativeForceLoadExpiryTime = this.expires ? buf.m_130258_() : 0L;
            } else {
                this.relativeForceLoadExpiryTime = 0L;
                this.relativeTimeForceLoaded = 0L;
                this.relativeTimeClaimed = 0L;
                this.expires = false;
                this.forceLoaded = false;
            }
        }

        public void write(FriendlyByteBuf buf, UUID teamId) {
            buf.m_130130_(this.x);
            buf.m_130130_(this.z);
            if (!teamId.equals(Util.f_137441_)) {
                buf.m_130103_(this.relativeTimeClaimed);
                buf.writeBoolean(this.forceLoaded);
                buf.writeBoolean(this.expires);
                if (this.forceLoaded) {
                    buf.m_130103_(this.relativeTimeForceLoaded);
                }
                if (this.expires) {
                    buf.m_130103_(this.relativeForceLoadExpiryTime);
                }
            }
        }

        public SingleChunk hidden() {
            return new SingleChunk(0L, this.x, this.z, null);
        }

        public MapChunk.DateInfo getDateInfo(boolean isClaimed, long now) {
            if (!isClaimed) {
                return MapChunk.NO_DATE_INFO;
            }
            Date claimed = new Date(now - this.relativeTimeClaimed);
            Date forceLoaded = this.forceLoaded ? new Date(now - this.relativeTimeForceLoaded) : null;
            Date expiry = this.forceLoaded && this.expires ? new Date(now + this.relativeForceLoadExpiryTime) : null;
            return new MapChunk.DateInfo(claimed, forceLoaded, expiry);
        }
    }
}

