/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.library.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;

public class PlayerClickBlockfaceUtil {
    private static final int[] sidesXY = new int[]{4, 5, 0, 1};
    private static final int[] sidesYZ = new int[]{0, 1, 2, 3};
    private static final int[] sidesZX = new int[]{2, 3, 4, 5};
    public static final float LO = 0.25f;
    public static final float HI = 0.75f;

    public static Direction getClickLocationDirection(Direction clickedFace, Vec3 clickLocation, BlockPos pos) {
        boolean rightCorner;
        int[] sides;
        double right;
        double left;
        int side = clickedFace.ordinal();
        double xIn = clickLocation.f_82479_ - (double)pos.m_123341_();
        double yIn = clickLocation.f_82480_ - (double)pos.m_123342_();
        double zIn = clickLocation.f_82481_ - (double)pos.m_123343_();
        int centeredSides = 0;
        if (side != 0 && side != 1) {
            centeredSides += yIn > 0.25 && yIn < 0.75 ? 1 : 0;
        }
        if (side != 2 && side != 3) {
            centeredSides += zIn > 0.25 && zIn < 0.75 ? 1 : 0;
        }
        if (side != 4 && side != 5) {
            centeredSides += xIn > 0.25 && xIn < 0.75 ? 1 : 0;
        }
        if (centeredSides == 2) {
            return Direction.values()[side].m_122424_();
        }
        switch (clickedFace) {
            case DOWN: 
            case UP: {
                left = zIn;
                right = xIn;
                sides = sidesZX;
                break;
            }
            case NORTH: 
            case SOUTH: {
                left = xIn;
                right = yIn;
                sides = sidesXY;
                break;
            }
            case WEST: 
            case EAST: {
                left = yIn;
                right = zIn;
                sides = sidesYZ;
                break;
            }
            default: {
                return Direction.UP;
            }
        }
        double cutoff = 0.25;
        boolean leftCorner = left < cutoff || left > 1.0 - cutoff;
        boolean bl = rightCorner = right < cutoff || right > 1.0 - cutoff;
        if (leftCorner && rightCorner) {
            return null;
        }
        boolean b0 = left > right;
        boolean b1 = left > 1.0 - right;
        int result = 0;
        result = b0 && b1 ? sides[0] : (!b0 && !b1 ? sides[1] : (b1 ? sides[2] : sides[3]));
        return Direction.values()[result].m_122424_();
    }
}

