/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.everythingcopper.integration;

import cy.jdkdigital.everythingcopper.common.item.ICopperItem;
import cy.jdkdigital.everythingcopper.crafting.recipe.WeatheringRecipe;
import cy.jdkdigital.everythingcopper.init.ModBlocks;
import cy.jdkdigital.everythingcopper.integration.WeatheringRecipeCategory;
import cy.jdkdigital.everythingcopper.util.WeatheringUtils;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraftforge.registries.ForgeRegistries;

@mezz.jei.api.JeiPlugin
public class JeiPlugin
implements IModPlugin {
    private static final ResourceLocation pluginId = new ResourceLocation("everythingcopper", "everythingcopper");
    public static RecipeType<WeatheringRecipe> WEATHERING_RECIPE_TYPE = RecipeType.create((String)"everythingcopper", (String)"weathering", WeatheringRecipe.class);

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.WEATHERING_STATION.get()), new RecipeType[]{WEATHERING_RECIPE_TYPE});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new WeatheringRecipeCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ArrayList weatheringRecipes = new ArrayList();
        ForgeRegistries.BLOCKS.getValues().forEach(block -> {
            if (block instanceof WeatheringCopper) {
                WeatheringCopper weatheringBlock = (WeatheringCopper)block;
                weatheringBlock.m_142123_(block.m_49966_()).ifPresent(newState -> {
                    ResourceLocation key = ForgeRegistries.BLOCKS.getKey(block);
                    weatheringRecipes.add(new WeatheringRecipe(new ResourceLocation("everythingcopper", "weathering_" + key.m_135815_()), new ItemStack((ItemLike)block), new ItemStack((ItemLike)newState.m_60734_())));
                });
            }
        });
        ForgeRegistries.ITEMS.getValues().forEach(item -> {
            if (item instanceof ICopperItem) {
                ResourceLocation key = ForgeRegistries.ITEMS.getKey(item);
                ItemStack sourceItem = new ItemStack((ItemLike)item);
                ItemStack newItem = new ItemStack((ItemLike)item);
                while (ICopperItem.canAge(newItem)) {
                    ICopperItem.setAge(newItem, WeatheringUtils.nextState(ICopperItem.getAge(newItem)));
                    weatheringRecipes.add(new WeatheringRecipe(new ResourceLocation("everythingcopper", "weathering_" + key.m_135815_()), sourceItem, newItem.m_41777_()));
                    sourceItem = newItem.m_41777_();
                }
            }
        });
        registration.addRecipes(WEATHERING_RECIPE_TYPE, weatheringRecipes);
    }

    @Nonnull
    public ResourceLocation getPluginUid() {
        return pluginId;
    }
}

