/*
 * Decompiled with CFR 0.152.
 */
package cofh.ensorcellation.common.event;

import cofh.ensorcellation.common.enchantment.DisplacementEnchantment;
import cofh.ensorcellation.common.enchantment.FireRebukeEnchantment;
import cofh.ensorcellation.common.enchantment.FrostRebukeEnchantment;
import cofh.ensorcellation.common.enchantment.override.FrostWalkerEnchantmentImp;
import cofh.ensorcellation.init.registries.ModEnchantments;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.MathHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.FrostWalkerEnchantment;
import net.minecraft.world.item.enchantment.ThornsEnchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ensorcellation")
public class HorseEnchEvents {
    private static final int HORSE_MODIFIER = 3;

    private HorseEnchEvents() {
    }

    @SubscribeEvent
    public static void handleLivingAttackEvent(LivingAttackEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        DamageSource source = event.getSource();
        Entity attacker = source.m_7639_();
        if (!(entity instanceof AbstractHorse)) {
            return;
        }
        ItemStack armor = entity.m_141942_(1).m_142196_();
        if (!armor.m_41619_()) {
            int encFrostWalker = Utils.getItemEnchantmentLevel((Enchantment)Enchantments.f_44974_, (ItemStack)armor);
            if (event.getSource().equals(entity.m_269291_().m_269047_()) && encFrostWalker > 0) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void handleLivingHurtEvent(LivingHurtEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        DamageSource source = event.getSource();
        Entity attacker = source.m_7639_();
        if (!(entity instanceof AbstractHorse)) {
            return;
        }
        ItemStack armor = entity.m_141942_(1).m_142196_();
        if (!armor.m_41619_()) {
            int encProtectionProjectile;
            int encProtectionExplosion;
            int encProtectionFall;
            int encProtectionFire;
            int totalProtection = 0;
            int encProtection = Utils.getItemEnchantmentLevel((Enchantment)Enchantments.f_44965_, (ItemStack)armor);
            if (encProtection > 0) {
                totalProtection += Enchantments.f_44965_.m_7205_(encProtection, source);
            }
            if ((encProtectionFire = Utils.getItemEnchantmentLevel((Enchantment)Enchantments.f_44966_, (ItemStack)armor)) > 0) {
                totalProtection += Enchantments.f_44966_.m_7205_(encProtection, source);
            }
            if ((encProtectionFall = Utils.getItemEnchantmentLevel((Enchantment)Enchantments.f_44967_, (ItemStack)armor)) > 0) {
                totalProtection += Enchantments.f_44967_.m_7205_(encProtection, source);
            }
            if ((encProtectionExplosion = Utils.getItemEnchantmentLevel((Enchantment)Enchantments.f_44968_, (ItemStack)armor)) > 0) {
                totalProtection += Enchantments.f_44968_.m_7205_(encProtection, source);
            }
            if ((encProtectionProjectile = Utils.getItemEnchantmentLevel((Enchantment)Enchantments.f_44969_, (ItemStack)armor)) > 0) {
                totalProtection += Enchantments.f_44969_.m_7205_(encProtection, source);
            }
            float damageReduction = Math.min((float)(totalProtection * 3), 20.0f);
            event.setAmount(event.getAmount() * (1.0f - damageReduction / 25.0f));
            if (attacker != null) {
                int encFrostRebuke;
                int encFireRebuke;
                int encDisplacement;
                int encThorns = Utils.getItemEnchantmentLevel((Enchantment)Enchantments.f_44972_, (ItemStack)armor);
                if (ThornsEnchantment.m_220316_((int)encThorns, (RandomSource)entity.m_217043_())) {
                    attacker.m_6469_(entity.m_269291_().m_269374_((Entity)entity), (float)ThornsEnchantment.m_220319_((int)encThorns, (RandomSource)MathHelper.RANDOM));
                }
                if (DisplacementEnchantment.shouldHit(encDisplacement = Utils.getItemEnchantmentLevel((Enchantment)((Enchantment)ModEnchantments.DISPLACEMENT.get()), (ItemStack)armor), entity.m_217043_())) {
                    DisplacementEnchantment.onHit(entity, attacker, encDisplacement);
                }
                if (FireRebukeEnchantment.shouldHit(encFireRebuke = Utils.getItemEnchantmentLevel((Enchantment)((Enchantment)ModEnchantments.FIRE_REBUKE.get()), (ItemStack)armor), entity.m_217043_())) {
                    FireRebukeEnchantment.onHit(entity, attacker, encFireRebuke);
                }
                if (FrostRebukeEnchantment.shouldHit(encFrostRebuke = Utils.getItemEnchantmentLevel((Enchantment)((Enchantment)ModEnchantments.FROST_REBUKE.get()), (ItemStack)armor), entity.m_217043_())) {
                    FrostRebukeEnchantment.onHit(entity, attacker, encFrostRebuke);
                }
            }
        }
    }

    @SubscribeEvent
    public static void handleLivingUpdateEvent(LivingEvent.LivingTickEvent event) {
        int encFrostWalker;
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof AbstractHorse)) {
            return;
        }
        ItemStack armor = entity.m_141942_(1).m_142196_();
        if (!armor.m_41619_() && (encFrostWalker = Utils.getItemEnchantmentLevel((Enchantment)Enchantments.f_44974_, (ItemStack)armor)) > 0) {
            FrostWalkerEnchantment.m_45018_((LivingEntity)entity, (Level)entity.f_19853_, (BlockPos)entity.m_20183_(), (int)encFrostWalker);
            FrostWalkerEnchantmentImp.freezeNearby(entity, entity.f_19853_, entity.m_20183_(), encFrostWalker);
        }
    }
}

