/*
 * Decompiled with CFR 0.152.
 */
package cofh.ensorcellation.common.config;

import cofh.core.common.config.IBaseConfig;
import cofh.ensorcellation.common.enchantment.override.FrostWalkerEnchantmentImp;
import cofh.ensorcellation.common.enchantment.override.MendingEnchantmentAlt;
import cofh.ensorcellation.common.enchantment.override.ThornsEnchantmentImp;
import cofh.lib.common.enchantment.EnchantmentCoFH;
import java.util.function.Supplier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.common.ForgeConfigSpec;

public class OverrideEnchantmentConfig
implements IBaseConfig {
    public static boolean enableMendingOverride = false;
    private Supplier<Boolean> enableProtection;
    private Supplier<Integer> levelProtection;
    private Supplier<Boolean> enableProtectionBlast;
    private Supplier<Integer> levelProtectionBlast;
    private Supplier<Boolean> enableProtectionFall;
    private Supplier<Integer> levelProtectionFall;
    private Supplier<Boolean> enableProtectionFire;
    private Supplier<Integer> levelProtectionFire;
    private Supplier<Boolean> enableProtectionProjectile;
    private Supplier<Integer> levelProtectionProjectile;
    private Supplier<Integer> levelFireAspect;
    private Supplier<Boolean> enableFrostWalker;
    private Supplier<Boolean> treasureFrostWalker;
    private Supplier<Integer> levelFrostWalker;
    private Supplier<Boolean> enableFreezeLava;
    private Supplier<Integer> levelKnockback;
    private Supplier<Integer> levelLooting;
    private Supplier<Boolean> enableThorns;
    private Supplier<Integer> levelThorns;
    private Supplier<Integer> chanceThorns;
    private Supplier<Boolean> alternateMending;
    private Supplier<Boolean> treasureMending;
    private Supplier<Integer> damageMending;

    public void apply(ForgeConfigSpec.Builder builder) {
        String treasure = "This sets whether or not the Enchantment is considered a 'treasure' enchantment.";
        String level = "This option adjusts the maximum allowable level for the Enchantment.";
        builder.push("Overrides");
        builder.push("Protection");
        this.enableProtection = builder.comment("If TRUE, the Protection Enchantment is replaced with a more configurable version which works on more items, such as Horse Armor.").define("Enable", true);
        this.levelProtection = builder.comment(level).defineInRange("Max Level", 4, 1, 10);
        builder.pop();
        builder.push("Blast Protection");
        this.enableProtectionBlast = builder.comment("If TRUE, the Blast Protection Enchantment is replaced with a more configurable version which works on more items, such as Horse Armor.").define("Enable", true);
        this.levelProtectionBlast = builder.comment(level).defineInRange("Max Level", 4, 1, 10);
        builder.pop();
        builder.push("Feather Falling");
        this.enableProtectionFall = builder.comment("If TRUE, the Feather Falling Enchantment is replaced with a more configurable version which works on more items, such as Horse Armor.").define("Enable", true);
        this.levelProtectionFall = builder.comment(level).defineInRange("Max Level", 4, 1, 10);
        builder.pop();
        builder.push("Fire Protection");
        this.enableProtectionFire = builder.comment("If TRUE, the Fire Protection Enchantment is replaced with a more configurable version which works on more items, such as Horse Armor.").define("Enable", true);
        this.levelProtectionFire = builder.comment(level).defineInRange("Max Level", 4, 1, 10);
        builder.pop();
        builder.push("Projectile Protection");
        this.enableProtectionProjectile = builder.comment("If TRUE, the Projectile Protection Enchantment is replaced with a more configurable version which works on more items, such as Horse Armor.").define("Enable", true);
        this.levelProtectionProjectile = builder.comment(level).defineInRange("Max Level", 4, 1, 10);
        builder.pop();
        builder.push("Fire Aspect");
        this.levelFireAspect = builder.comment(level).defineInRange("Max Level", 2, 1, 10);
        builder.pop();
        builder.push("Frost Walker");
        this.enableFrostWalker = builder.comment("If TRUE, the Frost Walker Enchantment is replaced with an improved and more configurable version which works on more items, such as Horse Armor.").define("Enable", true);
        this.treasureFrostWalker = builder.comment(treasure).define("Treasure", true);
        this.levelFrostWalker = builder.comment(level).defineInRange("Max Level", 2, 1, 10);
        this.enableFreezeLava = builder.comment("If TRUE, the Frost Walker Enchantment will also chill Lava into Glossed Magma.").define("Freeze Lava", true);
        builder.pop();
        builder.push("Knockback");
        this.levelKnockback = builder.comment(level).defineInRange("Max Level", 2, 1, 10);
        builder.pop();
        builder.push("Looting");
        this.levelLooting = builder.comment(level).defineInRange("Max Level", 3, 1, 10);
        builder.pop();
        builder.push("Thorns");
        this.enableThorns = builder.comment("If TRUE, the Thorns Enchantment is replaced with a more configurable version which works on more items, such as Shields and Horse Armor.").define("Enable", true);
        this.levelThorns = builder.comment(level).defineInRange("Max Level", 4, 1, 10);
        this.chanceThorns = builder.comment("Adjust this value to set the chance per level of the Enchantment firing (in percentage).").defineInRange("Effect Chance", 15, 1, 100);
        builder.pop();
        builder.push("Mending");
        this.alternateMending = builder.comment("If TRUE, the Mending Enchantment is replaced with a new Enchantment - Preservation. This enchantment allows you to repair items at an Anvil without paying an increasing XP cost for every time you repair it. Additionally, these repairs have a much lower chance of damaging the anvil.").define("Alternate Mending", false);
        this.treasureMending = builder.comment(treasure).define("Treasure", true);
        this.damageMending = builder.comment("Adjust this value to set the chance of an Anvil being damaged when used to repair an item with Preservation (in percentage). Only used if Alternate Mending (Preservation) is enabled.").defineInRange("Anvil Damage Chance", 3, 0, 12);
        builder.pop();
        builder.pop();
    }

    public void refresh() {
        Object enc;
        Enchantment enchantment = Enchantments.f_44965_;
        if (enchantment instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)enchantment;
            enc.setEnable(this.enableProtection.get().booleanValue());
            enc.setMaxLevel(this.levelProtection.get().intValue());
        }
        if ((enchantment = Enchantments.f_44968_) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)enchantment;
            enc.setEnable(this.enableProtectionBlast.get().booleanValue());
            enc.setMaxLevel(this.levelProtectionBlast.get().intValue());
        }
        if ((enchantment = Enchantments.f_44967_) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)enchantment;
            enc.setEnable(this.enableProtectionFall.get().booleanValue());
            enc.setMaxLevel(this.levelProtectionFall.get().intValue());
        }
        if ((enchantment = Enchantments.f_44966_) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)enchantment;
            enc.setEnable(this.enableProtectionFire.get().booleanValue());
            enc.setMaxLevel(this.levelProtectionFire.get().intValue());
        }
        if ((enchantment = Enchantments.f_44969_) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)enchantment;
            enc.setEnable(this.enableProtectionProjectile.get().booleanValue());
            enc.setMaxLevel(this.levelProtectionProjectile.get().intValue());
        }
        if ((enchantment = Enchantments.f_44981_) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)enchantment;
            enc.setMaxLevel(this.levelFireAspect.get().intValue());
        }
        if ((enchantment = Enchantments.f_44974_) instanceof FrostWalkerEnchantmentImp) {
            enc = (FrostWalkerEnchantmentImp)enchantment;
            enc.setEnable(this.enableFrostWalker.get().booleanValue());
            enc.setTreasureEnchantment(this.treasureFrostWalker.get().booleanValue());
            enc.setMaxLevel(this.levelFrostWalker.get().intValue());
            ((FrostWalkerEnchantmentImp)((Object)enc)).setFreezeLava(this.enableFreezeLava.get());
        }
        if ((enchantment = Enchantments.f_44980_) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)enchantment;
            enc.setMaxLevel(this.levelKnockback.get().intValue());
        }
        if ((enchantment = Enchantments.f_44982_) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)enchantment;
            enc.setMaxLevel(this.levelLooting.get().intValue());
        }
        if ((enchantment = Enchantments.f_44972_) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)enchantment;
            enc.setEnable(this.enableThorns.get().booleanValue());
            enc.setMaxLevel(this.levelThorns.get().intValue());
            ThornsEnchantmentImp.chance = this.chanceThorns.get();
        }
        if ((enchantment = Enchantments.f_44962_) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)enchantment;
            enableMendingOverride = this.alternateMending.get();
            enc.setEnable(this.alternateMending.get().booleanValue());
            enc.setTreasureEnchantment(this.treasureMending.get().booleanValue());
            MendingEnchantmentAlt.anvilDamage = (float)this.damageMending.get().intValue() / 100.0f;
        }
    }
}

