/*
 * Decompiled with CFR 0.152.
 */
package com.github.almostreliable.energymeter.client.gui;

import com.github.almostreliable.energymeter.client.gui.GenericButton;
import com.github.almostreliable.energymeter.client.gui.MeterScreen;
import com.github.almostreliable.energymeter.network.PacketHandler;
import com.github.almostreliable.energymeter.network.packets.SettingUpdatePacket;
import com.github.almostreliable.energymeter.util.GuiUtils;
import com.github.almostreliable.energymeter.util.TextUtils;
import com.github.almostreliable.energymeter.util.TypeEnums;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;

public class SettingButton
extends GenericButton {
    private static final String TEXTURE = "setting";
    private static final int TEXTURE_WIDTH = 63;
    private static final int TEXTURE_HEIGHT = 21;
    private final String label;
    private final Font font;
    private final TypeEnums.SETTING setting;
    private GuiUtils.TooltipBuilder tooltip;
    private GuiUtils.TooltipBuilder tooltipLong;

    SettingButton(MeterScreen screen, int pX, int pY, TypeEnums.SETTING setting) {
        super(screen, pX, pY, 63, 21);
        this.setting = setting;
        this.label = TextUtils.translateAsString(TypeEnums.TRANSLATE_TYPE.LABEL, setting.toString().toLowerCase()).toUpperCase();
        this.font = Minecraft.m_91087_().f_91062_;
        this.tooltip = this.setupTooltip(false);
        this.tooltipLong = this.setupTooltip(true);
    }

    @Override
    public void m_87963_(GuiGraphics guiGraphics, int mX, int mY, float partial) {
        super.m_87963_(guiGraphics, mX, mY, partial);
        int pX = (this.f_93618_ - this.font.m_92895_(this.label)) / 2 + this.m_252754_() + 1;
        Objects.requireNonNull(this.font);
        int pY = (this.f_93619_ - 9) / 2 + this.m_252907_() + 1;
        GuiUtils.renderText(guiGraphics, pX, pY, 1.0f, this.label, 0xF0F0F0);
    }

    @Override
    protected void clickHandler() {
        PacketHandler.CHANNEL.sendToServer((Object)new SettingUpdatePacket(this.setting));
        this.container.getEntity().updateSetting(this.setting);
        if (this.setting == TypeEnums.SETTING.ACCURACY) {
            this.screen.getIntervalBox().reset();
            this.screen.getThresholdBox().reset();
        }
        this.tooltip = this.setupTooltip(false);
        this.tooltipLong = this.setupTooltip(true);
    }

    @Override
    protected String getTexture() {
        return TEXTURE;
    }

    @Override
    protected int getTextureWidth() {
        return 63;
    }

    @Override
    protected int getTextureHeight() {
        return 21;
    }

    @Override
    protected GuiUtils.TooltipBuilder getTooltipBuilder() {
        return Screen.m_96638_() ? this.tooltipLong : this.tooltip;
    }

    private GuiUtils.TooltipBuilder setupTooltip(boolean longTooltip) {
        String settingKey = this.setting.toString().toLowerCase();
        GuiUtils.TooltipBuilder t = GuiUtils.TooltipBuilder.builder().addHeader(settingKey).addBlankLine();
        if (longTooltip) {
            t.addDescription(settingKey + "_desc_1");
            String description2 = "_desc_2";
            if (this.setting == TypeEnums.SETTING.NUMBER) {
                t.addDescription(settingKey + description2);
            }
            if (this.setting == TypeEnums.SETTING.MODE) {
                MutableComponent transfer = TextUtils.translate(TypeEnums.TRANSLATE_TYPE.MODE, TypeEnums.MODE.TRANSFER.toString().toLowerCase(), new ChatFormatting[0]).m_130946_(":");
                Style style1 = transfer.m_7383_().m_131148_(TextColor.m_131266_((int)40929));
                MutableComponent consumer = TextUtils.translate(TypeEnums.TRANSLATE_TYPE.MODE, TypeEnums.MODE.CONSUMER.toString().toLowerCase(), new ChatFormatting[0]).m_130946_(":");
                Style style2 = consumer.m_7383_().m_131148_(TextColor.m_131266_((int)12976383));
                t.addBlankLine().addComponent((Component)transfer.m_130948_(style1)).addDescription(settingKey + description2).addBlankLine().addComponent((Component)consumer.m_130948_(style2)).addDescription(settingKey + "_desc_3");
            }
            if (this.setting == TypeEnums.SETTING.ACCURACY) {
                MutableComponent exact = TextUtils.translate(TypeEnums.TRANSLATE_TYPE.ACCURACY, TypeEnums.ACCURACY.EXACT.toString().toLowerCase(), new ChatFormatting[0]).m_130946_(":");
                Style style3 = exact.m_7383_().m_131148_(TextColor.m_131266_((int)0xFF6600));
                MutableComponent interval = TextUtils.translate(TypeEnums.TRANSLATE_TYPE.ACCURACY, TypeEnums.ACCURACY.INTERVAL.toString().toLowerCase(), new ChatFormatting[0]).m_130946_(":");
                Style style4 = interval.m_7383_().m_131148_(TextColor.m_131266_((int)0xFF0066));
                t.addBlankLine().addComponent((Component)exact.m_130948_(style3)).addDescription(settingKey + description2).addBlankLine().addComponent((Component)interval.m_130948_(style4)).addDescription(settingKey + "_desc_3");
            }
            t.addBlankLine();
        }
        MutableComponent currentSetting = TextUtils.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, "current", ChatFormatting.GREEN).m_7220_((Component)TextUtils.colorize(": ", ChatFormatting.GREEN));
        switch (this.setting) {
            case NUMBER: {
                currentSetting.m_7220_((Component)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.NUMBER, this.container.getEntity().getNumberMode().toString().toLowerCase(), ChatFormatting.WHITE));
                break;
            }
            case MODE: {
                currentSetting.m_7220_((Component)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.MODE, this.container.getEntity().getMode().toString().toLowerCase(), ChatFormatting.WHITE));
                break;
            }
            case ACCURACY: {
                currentSetting.m_7220_((Component)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.ACCURACY, this.container.getEntity().getAccuracy().toString().toLowerCase(), ChatFormatting.WHITE));
            }
        }
        t.addComponent((Component)currentSetting).addBlankLine();
        if (!longTooltip) {
            t.addHoldAction("key.keyboard.left.shift", "action_4");
        }
        return t.addClickAction("action_3");
    }
}

