/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.client.renderer.base;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.teamresourceful.resourcefullib.client.CloseablePoseStack;
import java.util.function.Supplier;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import tech.alexnijjar.endermanoverhaul.common.entities.base.BaseEnderman;

public class CustomCarriedBlockLayer<T extends GeoAnimatable>
extends GeoRenderLayer<T> {
    private final BlockRenderDispatcher blockRenderer;
    private final Supplier<EnderMan> enderman;

    public CustomCarriedBlockLayer(GeoRenderer<T> entityRendererIn, BlockRenderDispatcher blockRenderDispatcher, Supplier<EnderMan> enderman) {
        super(entityRendererIn);
        this.blockRenderer = blockRenderDispatcher;
        this.enderman = enderman;
    }

    public void render(PoseStack poseStack, T animatable, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        BlockState state = this.enderman.get().m_32530_();
        if (state == null) {
            return;
        }
        try (CloseablePoseStack pose = new CloseablePoseStack(poseStack);){
            float lerped = Mth.m_14189_((float)partialTick, (float)this.enderman.get().f_20884_, (float)this.enderman.get().f_20883_);
            pose.m_252781_(Axis.f_252436_.m_252977_(-lerped));
            pose.m_85837_(0.0, (double)this.enderman.get().m_6095_().m_20680_().f_20378_ - 2.9, 0.0);
            GeoBone leftArm = this.getGeoModel().getBone("left_arm").orElse(null);
            if (leftArm == null) {
                return;
            }
            poseStack.m_252931_(leftArm.getModelRotationMatrix());
            pose.m_252781_(Axis.f_252529_.m_252977_(-28.6479f));
            pose.m_85837_(0.25, -2.2, 0.0);
            EnderMan enderMan = this.enderman.get();
            if (enderMan instanceof BaseEnderman) {
                BaseEnderman base = (BaseEnderman)enderMan;
                Vec3 offset = base.getHeldBlockOffset();
                pose.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
            }
            pose.m_252880_(0.0f, 0.6875f, -0.75f);
            pose.m_252781_(Axis.f_252529_.m_252977_(20.0f));
            pose.m_252781_(Axis.f_252436_.m_252977_(45.0f));
            pose.m_85837_(-1.35, 0.4, 1.35);
            pose.m_85841_(0.5f, 0.5f, 0.5f);
            pose.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            this.blockRenderer.m_110912_(state, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_);
        }
    }
}

