/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.common.items.pearls;

import dev.architectury.injectables.annotations.PlatformOnly;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnderpearlItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.alexnijjar.endermanoverhaul.common.constants.ConstantComponents;
import tech.alexnijjar.endermanoverhaul.common.entities.projectiles.ThrownSoulPearl;
import tech.alexnijjar.endermanoverhaul.common.tags.ModEntityTypeTags;

public class SoulPearlItem
extends EnderpearlItem {
    public SoulPearlItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand usedHand) {
        if (player.m_6144_()) {
            return InteractionResultHolder.m_19098_((Object)player.m_21120_(usedHand));
        }
        ItemStack itemStack = player.m_21120_(usedHand);
        int id = itemStack.m_41784_().m_128451_("BoundEntity");
        Entity entity = level.m_6815_(id);
        if (entity == null) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11857_, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.m_213780_().m_188501_() * 0.4f + 0.8f));
        player.m_36335_().m_41524_((Item)this, 20);
        if (!level.m_5776_()) {
            ThrownSoulPearl pearl = new ThrownSoulPearl(level, (LivingEntity)player, entity);
            pearl.m_37446_(itemStack);
            pearl.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f, 1.0f);
            level.m_7967_((Entity)pearl);
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
    }

    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity interactionTarget, @NotNull InteractionHand usedHand) {
        if (!player.m_9236_().m_5776_() && player.m_6144_() && !interactionTarget.m_6095_().m_204039_(ModEntityTypeTags.CANT_BE_TELEPORTED)) {
            CompoundTag originalTag = stack.m_41784_();
            if (originalTag.m_128441_("BoundEntity") && interactionTarget.m_19879_() == originalTag.m_128451_("BoundEntity")) {
                return InteractionResult.PASS;
            }
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(1);
            CompoundTag tag = copy.m_41784_();
            tag.m_128405_("BoundEntity", interactionTarget.m_19879_());
            tag.m_128359_("BoundType", BuiltInRegistries.f_256780_.m_7981_((Object)interactionTarget.m_6095_()).toString());
            player.m_5661_((Component)Component.m_237110_((String)"tooltip.endermanoverhaul.bound_to", (Object[])new Object[]{interactionTarget.m_5446_().getString()}), true);
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11862_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            if (stack.m_41613_() == 1) {
                player.m_21008_(usedHand, copy);
            } else {
                stack.m_41774_(1);
                if (!player.m_150109_().m_36054_(copy)) {
                    player.m_36176_(copy, false);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6880_(stack, player, interactionTarget, usedHand);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        tooltipComponents.add(ConstantComponents.SOUL_PEARL_TOOLTIP_1);
        tooltipComponents.add(ConstantComponents.SOUL_PEARL_TOOLTIP_2);
        if (level == null) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("BoundEntity")) {
            int id = tag.m_128451_("BoundEntity");
            String typeString = tag.m_128461_("BoundType");
            Entity entity = level.m_6815_(id);
            if (entity == null && typeString == null) {
                tooltipComponents.add(ConstantComponents.NOT_BOUND);
            } else {
                EntityType type = (EntityType)BuiltInRegistries.f_256780_.m_7745_(new ResourceLocation(typeString));
                Component displayName = entity == null && type != null ? type.m_20676_() : entity.m_5446_();
                tooltipComponents.add((Component)Component.m_237110_((String)"tooltip.endermanoverhaul.bound_to", (Object[])new Object[]{displayName.getString()}).m_130940_(ChatFormatting.GREEN));
            }
        } else {
            tooltipComponents.add(ConstantComponents.NOT_BOUND);
        }
    }

    public void m_6883_(@NotNull ItemStack stack, Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        int id;
        Entity boundEntity;
        if (level.m_5776_()) {
            return;
        }
        if (level.m_46467_() % 100L != 0L) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("BoundEntity") && (boundEntity = level.m_6815_(id = tag.m_128451_("BoundEntity"))) == null) {
            tag.m_128473_("BoundEntity");
            tag.m_128473_("BoundType");
        }
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        return stack.m_41782_() && stack.m_41784_().m_128441_("BoundEntity");
    }

    @PlatformOnly(value={"forge"})
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }
}

