/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.common.misc;

import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import shetiphian.enderchests.common.misc.ChestInfoHelper;

public class StackHelper {
    public static final String[] BASE_CODES = new String[]{"000", "111", "222", "333", "444", "555", "666", "777", "888", "999", "AAA", "BBB", "CCC", "DDD", "EEE", "FFF"};

    public static ItemStack create(Item item, String code, String ownerID, @Nonnull ItemStack personalItem) {
        ItemStack stack = StackHelper.create(item, code, !personalItem.m_41619_() ? ownerID : "all");
        if (!personalItem.m_41619_()) {
            String id = ForgeRegistries.ITEMS.getKey((Object)personalItem.m_41720_()).toString();
            StackHelper.getTag(stack).m_128359_("personal", id);
        }
        return stack;
    }

    public static ItemStack create(Item item, String code, String ownerID) {
        ItemStack stack = new ItemStack((ItemLike)item);
        StackHelper.setCode(stack, code);
        StackHelper.setOwner(stack, ownerID);
        return stack;
    }

    public static void setOwner(ItemStack stack, String ownerID) {
        if (Strings.isNullOrEmpty((String)ownerID) || ownerID.equalsIgnoreCase("all")) {
            ownerID = "all";
        }
        StackHelper.getTag(stack).m_128359_("owner", ownerID);
    }

    public static void setCode(ItemStack stack, String code) {
        StackHelper.getTag(stack).m_128359_("code", StackHelper.formatCode(code));
    }

    public static String getOwnerID(ItemStack stack) {
        if (!stack.m_41619_()) {
            if (StackHelper.getTag(stack).m_128441_("owner")) {
                return StackHelper.getTag(stack).m_128461_("owner");
            }
            StackHelper.setOwner(stack, "all");
        }
        return "all";
    }

    public static String getOwnerName(ItemStack stack) {
        return ChestInfoHelper.getDisplayNameFromOwnerID(StackHelper.getOwnerID(stack));
    }

    public static String getCode(ItemStack stack) {
        if (StackHelper.getTag(stack).m_128441_("code")) {
            return StackHelper.formatCode(StackHelper.getTag(stack).m_128461_("code"));
        }
        StackHelper.setCode(stack, "000");
        return "000";
    }

    @Nonnull
    public static ItemStack getPersonalItem(ItemStack stack) {
        String id = StackHelper.getTag(stack).m_128461_("personal");
        if (!Strings.isNullOrEmpty((String)id)) {
            try {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(id));
                if (item != null) {
                    return new ItemStack((ItemLike)item, 1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ItemStack.f_41583_;
    }

    public static boolean isPublic(ItemStack stack) {
        String ownerID = StackHelper.getOwnerID(stack);
        return Strings.isNullOrEmpty((String)ownerID) || ownerID.equalsIgnoreCase("all");
    }

    public static boolean isPrivate(ItemStack stack) {
        return !StackHelper.isPublic(stack) && !StackHelper.isTeam(stack);
    }

    public static boolean isTeam(ItemStack stack) {
        String ownerID = StackHelper.getOwnerID(stack);
        return !Strings.isNullOrEmpty((String)ownerID) && ownerID.startsWith("#");
    }

    private static CompoundTag getTag(ItemStack stack) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        return stack.m_41783_();
    }

    private static String formatCode(String code) {
        if (Strings.isNullOrEmpty((String)code)) {
            return "000";
        }
        if (((String)(code = ((String)code).toUpperCase())).length() != 3) {
            while (((String)code).length() < 3) {
                code = "0" + (String)code;
            }
            code = ((String)code).substring(0, 3);
        }
        if (((String)code).matches("[0-9A-F]{3}")) {
            return code;
        }
        char[] parts = ((String)code).toCharArray();
        for (int index = 0; index < 3; ++index) {
            if (!("" + parts[index]).matches("[^0-9A-F]")) continue;
            parts[index] = 48;
        }
        return "" + parts[0] + parts[1] + parts[2];
    }
}

