/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.embeddiumplus.mixins.impl.frames;

import java.util.LinkedList;
import java.util.Objects;
import me.srrapero720.embeddiumplus.EmbPlusConfig;
import me.srrapero720.embeddiumplus.features.frame_overlay.MinFrameProvider;
import me.srrapero720.embeddiumplus.mixins.impl.frames.FpsAccessorMixin;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ForgeGui.class})
public class FrameCounterMixin {
    @Unique
    private int embeddiumExtras$lastMeasuredFPS;
    @Unique
    private String embeddiumExtras$runningAverageFPS;
    @Unique
    private final LinkedList<Integer> embeddiumExtras$fpsRunningAverageQueue = new LinkedList();

    @Inject(method={"render"}, at={@At(value="HEAD")})
    public void render(GuiGraphics matrixStack, float tickDelta, CallbackInfo info) {
        String displayString;
        switch ((EmbPlusConfig.Complexity)((Object)EmbPlusConfig.fpsCounterMode.get())) {
            case SIMPLE: {
                int fps = FpsAccessorMixin.getFps();
                displayString = String.valueOf(fps);
                break;
            }
            case ADVANCED: {
                int fps = FpsAccessorMixin.getFps();
                displayString = this.GetAdvancedFPSString(fps);
                break;
            }
            default: {
                return;
            }
        }
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91066_.f_92063_ && !client.f_91066_.f_92065_) {
            return;
        }
        float textPos = ((Integer)EmbPlusConfig.fpsCounterPosition.get()).intValue();
        int textAlpha = 200;
        int textColor = 0xFFFFFF;
        float fontScale = 0.75f;
        double guiScale = client.m_91268_().m_85449_();
        if (guiScale > 0.0) {
            textPos /= (float)guiScale;
        }
        float maxTextPosX = client.m_91268_().m_85445_() - client.f_91062_.m_92895_(displayString);
        int n = client.m_91268_().m_85446_();
        Objects.requireNonNull(client.f_91062_);
        float maxTextPosY = n - 9;
        textPos = Math.min(textPos, maxTextPosX);
        int drawColor = (textAlpha & 0xFF) << 24 | textColor;
        matrixStack.drawString(client.f_91062_, displayString, textPos, textPos, drawColor, true);
    }

    private String GetAdvancedFPSString(int fps) {
        MinFrameProvider.recalculate();
        if (this.embeddiumExtras$lastMeasuredFPS != fps) {
            this.embeddiumExtras$lastMeasuredFPS = fps;
            if (this.embeddiumExtras$fpsRunningAverageQueue.size() > 14) {
                this.embeddiumExtras$fpsRunningAverageQueue.poll();
            }
            this.embeddiumExtras$fpsRunningAverageQueue.offer(fps);
            int totalFps = 0;
            int frameCount = 0;
            for (Integer frameTime : this.embeddiumExtras$fpsRunningAverageQueue) {
                totalFps += frameTime.intValue();
                ++frameCount;
            }
            int average = totalFps / frameCount;
            this.embeddiumExtras$runningAverageFPS = String.valueOf(average);
        }
        return fps + " | MIN " + MinFrameProvider.getLastMinFrame() + " | AVG " + this.embeddiumExtras$runningAverageFPS;
    }
}

