/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.embeddiumplus.mixins.impl.dynamiclights.lightsource;

import me.srrapero720.dynamiclights.DynamicLightSource;
import me.srrapero720.dynamiclights.LambDynLights;
import me.srrapero720.dynamiclights.api.DynamicLightHandlers;
import me.srrapero720.embeddiumplus.EmbPlusConfig;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PrimedTnt.class})
public abstract class TntEntityMixin
extends Entity
implements DynamicLightSource {
    @Unique
    private int embeddiumPlus$startFuseTimer = 80;
    @Unique
    private int lambdynlights$luminance;

    @Shadow
    public abstract int m_32100_();

    public TntEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V"}, at={@At(value="TAIL")})
    private void onNew(EntityType<? extends PrimedTnt> entityType, Level world, CallbackInfo ci) {
        this.embeddiumPlus$startFuseTimer = this.m_32100_();
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void onTick(CallbackInfo ci) {
        if (this.m_20193_().m_5776_()) {
            if (!LambDynLights.isEnabled()) {
                return;
            }
            if (this.m_213877_()) {
                this.tdv$setDynamicLightEnabled(false);
            } else {
                if (!((Boolean)EmbPlusConfig.tileEntityLighting.get()).booleanValue() || !DynamicLightHandlers.canLightUp(this)) {
                    this.tdv$resetDynamicLight();
                } else {
                    this.tdv$dynamicLightTick();
                }
                LambDynLights.updateTracking(this);
            }
        }
    }

    @Override
    public void tdv$dynamicLightTick() {
        if (this.m_6060_()) {
            this.lambdynlights$luminance = 15;
        } else if (LambDynLights.isEnabled()) {
            int fuse = this.m_32100_() / this.embeddiumPlus$startFuseTimer;
            this.lambdynlights$luminance = (int)((double)(-(fuse * fuse)) * 10.0) + 10;
        } else {
            this.lambdynlights$luminance = 10;
        }
    }

    @Override
    public int tdv$getLuminance() {
        return this.lambdynlights$luminance;
    }
}

