/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.render.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.common.ParticleVertex;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SingleQuadParticle.class})
public abstract class BillboardParticleMixin
extends Particle {
    @Shadow
    public abstract float m_5902_(float var1);

    @Shadow
    protected abstract float m_5970_();

    @Shadow
    protected abstract float m_5952_();

    @Shadow
    protected abstract float m_5951_();

    @Shadow
    protected abstract float m_5950_();

    protected BillboardParticleMixin(ClientLevel world, double x, double y, double z) {
        super(world, x, y, z);
    }

    @Inject(method={"buildGeometry"}, at={@At(value="HEAD")}, cancellable=true)
    private void buildGeometryFast(VertexConsumer vertexConsumer, Camera camera, float tickDelta, CallbackInfo ci) {
        Quaternionf quaternion;
        VertexBufferWriter writer = VertexBufferWriter.tryOf(vertexConsumer);
        if (writer == null) {
            return;
        }
        ci.cancel();
        Vec3 vec3d = camera.m_90583_();
        float x = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107209_, (double)this.f_107212_) - vec3d.m_7096_());
        float y = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107210_, (double)this.f_107213_) - vec3d.m_7098_());
        float z = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107211_, (double)this.f_107214_) - vec3d.m_7094_());
        if (this.f_107231_ == 0.0f) {
            quaternion = camera.m_253121_();
        } else {
            float angle = Mth.m_14179_((float)tickDelta, (float)this.f_107204_, (float)this.f_107231_);
            quaternion = new Quaternionf((Quaternionfc)camera.m_253121_());
            quaternion.rotateZ(angle);
        }
        float size = this.m_5902_(tickDelta);
        int light = this.m_6355_(tickDelta);
        float minU = this.m_5970_();
        float maxU = this.m_5952_();
        float minV = this.m_5951_();
        float maxV = this.m_5950_();
        int color = ColorABGR.pack(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_);
        try (MemoryStack stack = MemoryStack.stackPush();){
            long buffer;
            long ptr = buffer = stack.nmalloc(112);
            BillboardParticleMixin.writeVertex(ptr, quaternion, -1.0f, -1.0f, x, y, z, maxU, maxV, color, light, size);
            BillboardParticleMixin.writeVertex(ptr += 28L, quaternion, -1.0f, 1.0f, x, y, z, maxU, minV, color, light, size);
            BillboardParticleMixin.writeVertex(ptr += 28L, quaternion, 1.0f, 1.0f, x, y, z, minU, minV, color, light, size);
            BillboardParticleMixin.writeVertex(ptr += 28L, quaternion, 1.0f, -1.0f, x, y, z, minU, maxV, color, light, size);
            ptr += 28L;
            writer.push(stack, buffer, 4, ParticleVertex.FORMAT);
        }
    }

    @Unique
    private static void writeVertex(long buffer, Quaternionf rotation, float posX, float posY, float originX, float originY, float originZ, float u, float v, int color, int light, float size) {
        float q0x = rotation.x();
        float q0y = rotation.y();
        float q0z = rotation.z();
        float q0w = rotation.w();
        float q1x = q0w * posX - q0z * posY;
        float q1y = q0w * posY + q0z * posX;
        float q1w = q0x * posY - q0y * posX;
        float q1z = -(q0x * posX) - q0y * posY;
        float q2x = -q0x;
        float q2y = -q0y;
        float q2z = -q0z;
        float q2w = q0w;
        float q3x = q1z * q2x + q1x * q2w + q1y * q2z - q1w * q2y;
        float q3y = q1z * q2y - q1x * q2z + q1y * q2w + q1w * q2x;
        float q3z = q1z * q2z + q1x * q2y - q1y * q2x + q1w * q2w;
        float fx = q3x * size + originX;
        float fy = q3y * size + originY;
        float fz = q3z * size + originZ;
        ParticleVertex.put(buffer, fx, fy, fz, u, v, color, light);
    }
}

