/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.model;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Predicate;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.MultiPartBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.MultipartModelData;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={MultiPartBakedModel.class})
public class MultipartBakedModelMixin {
    @Unique
    private final Map<BlockState, BakedModel[]> stateCacheFast = new Reference2ReferenceOpenHashMap();
    @Unique
    private final StampedLock lock = new StampedLock();
    @Shadow
    @Final
    private List<Pair<Predicate<BlockState>, BakedModel>> f_119459_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unique
    private BakedModel[] getModelComponents(BlockState state) {
        BakedModel[] models;
        long readStamp = this.lock.readLock();
        try {
            models = this.stateCacheFast.get(state);
        }
        finally {
            this.lock.unlockRead(readStamp);
        }
        if (models == null) {
            long writeStamp = this.lock.writeLock();
            try {
                ArrayList<BakedModel> modelList = new ArrayList<BakedModel>(this.f_119459_.size());
                for (Pair<Predicate<BlockState>, BakedModel> pair : this.f_119459_) {
                    if (!((Predicate)pair.getLeft()).test(state)) continue;
                    modelList.add((BakedModel)pair.getRight());
                }
                models = (BakedModel[])modelList.toArray(BakedModel[]::new);
                this.stateCacheFast.put(state, models);
            }
            finally {
                this.lock.unlockWrite(writeStamp);
            }
        }
        return models;
    }

    @Overwrite
    public List<BakedQuad> getQuads(BlockState state, Direction face, RandomSource random, ModelData modelData, RenderType renderLayer) {
        if (state == null) {
            return Collections.emptyList();
        }
        BakedModel[] models = this.getModelComponents(state);
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        long seed = random.m_188505_();
        for (BakedModel model : models) {
            random.m_188584_(seed);
            if (renderLayer != null && !model.getRenderTypes(state, random, modelData).contains(renderLayer)) continue;
            quads.addAll(model.getQuads(state, face, random, MultipartModelData.resolve((ModelData)modelData, (BakedModel)model), renderLayer));
        }
        return quads;
    }

    @Overwrite
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource random, @NotNull ModelData data) {
        BakedModel[] models = this.getModelComponents(state);
        long seed = random.m_188505_();
        LinkedList<ChunkRenderTypeSet> renderTypeSets = new LinkedList<ChunkRenderTypeSet>();
        for (BakedModel model : models) {
            random.m_188584_(seed);
            renderTypeSets.add(model.getRenderTypes(state, random, data));
        }
        return ChunkRenderTypeSet.union(renderTypeSets);
    }
}

