/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.vertex.format.impl;

import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexAttributeFormat;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexFormat;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.material.Material;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkVertexEncoder;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkVertexType;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.VanillaLikeChunkMeshAttribute;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.util.ColorU8;
import org.lwjgl.system.MemoryUtil;

public class VanillaLikeChunkVertex
implements ChunkVertexType {
    public static final int STRIDE = 28;
    public static final GlVertexFormat<VanillaLikeChunkMeshAttribute> VERTEX_FORMAT = GlVertexFormat.builder(VanillaLikeChunkMeshAttribute.class, 28).addElement(VanillaLikeChunkMeshAttribute.POSITION, 0, GlVertexAttributeFormat.FLOAT, 3, false, false).addElement(VanillaLikeChunkMeshAttribute.COLOR, 12, GlVertexAttributeFormat.UNSIGNED_INT, 1, false, true).addElement(VanillaLikeChunkMeshAttribute.TEXTURE_UV, 16, GlVertexAttributeFormat.FLOAT, 2, false, false).addElement(VanillaLikeChunkMeshAttribute.DRAW_PARAMS_LIGHT, 24, GlVertexAttributeFormat.UNSIGNED_INT, 1, false, true).build();

    public GlVertexFormat<VanillaLikeChunkMeshAttribute> getVertexFormat() {
        return VERTEX_FORMAT;
    }

    @Override
    public ChunkVertexEncoder getEncoder() {
        return (ptr, material, vertex, sectionIndex) -> {
            MemoryUtil.memPutFloat((long)(ptr + 0L), (float)vertex.x);
            MemoryUtil.memPutFloat((long)(ptr + 4L), (float)vertex.y);
            MemoryUtil.memPutFloat((long)(ptr + 8L), (float)vertex.z);
            MemoryUtil.memPutInt((long)(ptr + 12L), (int)VanillaLikeChunkVertex.encodeColor(vertex.color));
            MemoryUtil.memPutFloat((long)(ptr + 16L), (float)VanillaLikeChunkVertex.encodeTexture(vertex.u));
            MemoryUtil.memPutFloat((long)(ptr + 20L), (float)VanillaLikeChunkVertex.encodeTexture(vertex.v));
            MemoryUtil.memPutInt((long)(ptr + 24L), (int)(VanillaLikeChunkVertex.encodeDrawParameters(material, sectionIndex) << 0 | VanillaLikeChunkVertex.encodeLight(vertex.light) << 16));
            return ptr + 28L;
        };
    }

    @Override
    public String getDefine() {
        return "VERTEX_FORMAT_FULL";
    }

    private static int encodeDrawParameters(Material material, int sectionIndex) {
        return (sectionIndex & 0xFF) << 8 | (material.bits() & 0xFF) << 0;
    }

    private static int encodeColor(int color) {
        float brightness = ColorU8.byteToNormalizedFloat(ColorABGR.unpackAlpha(color));
        int r = ColorU8.normalizedFloatToByte(ColorU8.byteToNormalizedFloat(ColorABGR.unpackRed(color)) * brightness);
        int g = ColorU8.normalizedFloatToByte(ColorU8.byteToNormalizedFloat(ColorABGR.unpackGreen(color)) * brightness);
        int b = ColorU8.normalizedFloatToByte(ColorU8.byteToNormalizedFloat(ColorABGR.unpackBlue(color)) * brightness);
        return ColorABGR.pack(r, g, b, 0);
    }

    private static int encodeLight(int light) {
        int block = light & 0xFF;
        int sky = light >> 16 & 0xFF;
        return block << 0 | sky << 8;
    }

    private static float encodeTexture(float value) {
        return Math.min(0.99999994f, value);
    }
}

