/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.lists;

import java.util.ArrayDeque;
import java.util.EnumMap;
import java.util.Map;
import java.util.Queue;
import java.util.function.Consumer;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkUpdateType;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.lists.SortedRenderLists;

public class VisibleChunkCollector
implements Consumer<RenderSection> {
    private final SortedRenderLists.Builder sortedRenderLists;
    private final EnumMap<ChunkUpdateType, ArrayDeque<RenderSection>> sortedRebuildLists;

    public VisibleChunkCollector(int frame) {
        this.sortedRenderLists = new SortedRenderLists.Builder(frame);
        this.sortedRebuildLists = new EnumMap(ChunkUpdateType.class);
        for (ChunkUpdateType type : ChunkUpdateType.values()) {
            this.sortedRebuildLists.put(type, new ArrayDeque());
        }
    }

    @Override
    public void accept(RenderSection section) {
        this.sortedRenderLists.add(section);
        this.addToRebuildLists(section);
    }

    private void addToRebuildLists(RenderSection section) {
        Queue queue;
        ChunkUpdateType type = section.getPendingUpdate();
        if (type != null && section.getBuildCancellationToken() == null && (queue = (Queue)this.sortedRebuildLists.get((Object)type)).size() < type.getMaximumQueueSize()) {
            queue.add(section);
        }
    }

    public SortedRenderLists createRenderLists() {
        return this.sortedRenderLists.build();
    }

    public Map<ChunkUpdateType, ArrayDeque<RenderSection>> getRebuildLists() {
        return this.sortedRebuildLists;
    }
}

