/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.compatibility.checks;

import java.util.List;
import me.jellysquid.mods.sodium.client.compatibility.checks.Configuration;
import net.minecraft.util.NativeModuleLister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Sodium-Win32ModuleChecks");
    private static final String[] RTSS_HOOKS_MODULE_NAMES = new String[]{"RTSSHooks64.dll", "RTSSHooks.dll"};

    public static void checkModules() {
        List modules;
        try {
            modules = NativeModuleLister.m_184666_();
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to scan the currently loaded modules", t);
            return;
        }
        if (modules.isEmpty()) {
            return;
        }
        if (Configuration.WIN32_RTSS_HOOKS && ModuleScanner.isModuleLoaded(modules, RTSS_HOOKS_MODULE_NAMES)) {
            throw new RuntimeException("RivaTuner Statistics Server (RTSS) is not compatible with Sodium, see here for more details: https://github.com/CaffeineMC/sodium-fabric/wiki/Known-Issues#rtss-incompatible");
        }
    }

    private static boolean isModuleLoaded(List<NativeModuleLister.NativeModuleInfo> modules, String[] names) {
        for (String name : names) {
            for (NativeModuleLister.NativeModuleInfo module : modules) {
                if (!module.f_184690_.equalsIgnoreCase(name)) continue;
                return true;
            }
        }
        return false;
    }
}

