/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.registries;

import elucent.eidolon.Eidolon;
import elucent.eidolon.api.spells.Sign;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.AABB;

public class AdvancementTriggers {
    public static PlayerTrigger WICKED;
    public static PlayerTrigger SACRED;
    public static PlayerTrigger SACRIFICE;
    public static PlayerTrigger INCENSE;
    public static PlayerTrigger VSACRIFICE;
    public static PlayerTrigger LAY_ON_HANDS;
    public static PlayerTrigger ZOMBIFY;
    public static PlayerTrigger CURE_ZOMBIE;
    public static PlayerTrigger ENTHRALL;
    public static PlayerTrigger SMITE;
    public static PlayerTrigger FLAME;
    public static PlayerTrigger FROST;

    public static void init() {
        WICKED = AdvancementTriggers.register(new PlayerTrigger(Eidolon.prefix("wicked_path")));
        SACRED = AdvancementTriggers.register(new PlayerTrigger(Eidolon.prefix("sacred_path")));
        SACRIFICE = AdvancementTriggers.register(new PlayerTrigger(Eidolon.prefix("sacrifice")));
        INCENSE = AdvancementTriggers.register(new PlayerTrigger(Eidolon.prefix("incense")));
        VSACRIFICE = AdvancementTriggers.register(new PlayerTrigger(Eidolon.prefix("villager_sacrifice")));
        LAY_ON_HANDS = AdvancementTriggers.register(new PlayerTrigger(Eidolon.prefix("lay_on_hands")));
        ZOMBIFY = AdvancementTriggers.register(new PlayerTrigger(Eidolon.prefix("zombify")));
        CURE_ZOMBIE = AdvancementTriggers.register(new PlayerTrigger(Eidolon.prefix("cure_zombie")));
        ENTHRALL = AdvancementTriggers.register(new PlayerTrigger(Eidolon.prefix("enthrall_undead")));
        SMITE = AdvancementTriggers.register(new PlayerTrigger(Eidolon.prefix("smite_undead")));
        FLAME = AdvancementTriggers.register(new PlayerTrigger(Eidolon.prefix("flame_spell")));
        FROST = AdvancementTriggers.register(new PlayerTrigger(Eidolon.prefix("frost_spell")));
    }

    public static void rewardNearbyPlayers(PlayerTrigger criteria, ServerLevel level, BlockPos pos, int radius) {
        AABB aabb = new AABB(pos).m_82400_((double)radius);
        for (ServerPlayer player : level.m_6907_()) {
            if (!aabb.m_82393_(player.m_20185_(), player.m_20186_(), player.m_20189_())) continue;
            criteria.m_222618_(player);
        }
    }

    public static <T extends CriterionTrigger<?>> T register(T trigger) {
        return (T)CriteriaTriggers.m_10595_(trigger);
    }

    public static void triggerSign(Sign sign, ServerPlayer player) {
        switch (sign.getRegistryName().m_135815_()) {
            case "wicked": {
                WICKED.m_222618_(player);
                break;
            }
            case "sacred": {
                SACRED.m_222618_(player);
            }
        }
    }

    public static void triggerResearch(String research, ServerPlayer player) {
        switch (research) {
            case "eidolon:frost": {
                FROST.m_222618_(player);
                break;
            }
            case "eidolon:flames": {
                FLAME.m_222618_(player);
                break;
            }
            case "sacrifice_mob": {
                SACRIFICE.m_222618_(player);
                break;
            }
            case "basic_incense": {
                INCENSE.m_222618_(player);
                break;
            }
            case "sacrifice_villager": {
                VSACRIFICE.m_222618_(player);
                break;
            }
            case "heal_villager": {
                LAY_ON_HANDS.m_222618_(player);
                break;
            }
            case "zombify_villager": {
                ZOMBIFY.m_222618_(player);
                break;
            }
            case "cure_zombie": {
                CURE_ZOMBIE.m_222618_(player);
                break;
            }
            case "enthrall": {
                ENTHRALL.m_222618_(player);
                break;
            }
            case "smite": {
                SMITE.m_222618_(player);
            }
        }
    }
}

