/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.network;

import elucent.eidolon.Eidolon;
import elucent.eidolon.capability.ISoul;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class SoulUpdatePacket {
    final boolean isPlayer;
    UUID uuid;
    int id;
    CompoundTag tag;

    public SoulUpdatePacket(int id, CompoundTag tag) {
        this.isPlayer = false;
        this.id = id;
        this.tag = tag;
    }

    public SoulUpdatePacket(UUID uuid, CompoundTag tag) {
        this.isPlayer = true;
        this.uuid = uuid;
        this.tag = tag;
    }

    public SoulUpdatePacket(LivingEntity entity) {
        this.isPlayer = entity instanceof Player;
        if (this.isPlayer) {
            this.uuid = entity.m_20148_();
        } else {
            this.id = entity.m_19879_();
        }
        entity.getCapability(ISoul.INSTANCE, null).ifPresent(k -> {
            this.tag = (CompoundTag)((INBTSerializable)k).serializeNBT();
        });
    }

    public SoulUpdatePacket(Player entity) {
        this.isPlayer = true;
        this.uuid = entity.m_20148_();
        entity.getCapability(ISoul.INSTANCE, null).ifPresent(k -> {
            this.tag = (CompoundTag)((INBTSerializable)k).serializeNBT();
        });
    }

    public static void encode(SoulUpdatePacket object, FriendlyByteBuf buffer) {
        buffer.writeBoolean(object.isPlayer);
        if (object.isPlayer) {
            buffer.m_130077_(object.uuid);
        } else {
            buffer.writeInt(object.id);
        }
        buffer.m_130079_(object.tag);
    }

    public static SoulUpdatePacket decode(FriendlyByteBuf buffer) {
        if (buffer.readBoolean()) {
            return new SoulUpdatePacket(buffer.m_130259_(), buffer.m_130260_());
        }
        return new SoulUpdatePacket(buffer.readInt(), buffer.m_130260_());
    }

    public static void consume(SoulUpdatePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Player e;
            assert (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT);
            Level world = Eidolon.proxy.getWorld();
            Object object = e = packet.isPlayer ? world.m_46003_(packet.uuid) : (LivingEntity)world.m_6815_(packet.id);
            if (e != null) {
                e.getCapability(ISoul.INSTANCE, null).ifPresent(k -> ((INBTSerializable)k).deserializeNBT((Tag)packet.tag));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

