/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.event;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import elucent.eidolon.Config;
import elucent.eidolon.Eidolon;
import elucent.eidolon.api.ritual.Ritual;
import elucent.eidolon.capability.IKnowledge;
import elucent.eidolon.capability.IPlayerData;
import elucent.eidolon.capability.IReputation;
import elucent.eidolon.capability.ISoul;
import elucent.eidolon.capability.KnowledgeCommand;
import elucent.eidolon.capability.ReputationCommand;
import elucent.eidolon.common.entity.ZombieBruteEntity;
import elucent.eidolon.common.entity.ai.FollowOwnerGoal;
import elucent.eidolon.common.entity.ai.PriestBarterGoal;
import elucent.eidolon.common.entity.ai.ThrallTargetGoal;
import elucent.eidolon.common.entity.ai.WitchBarterGoal;
import elucent.eidolon.common.item.BonelordArmorItem;
import elucent.eidolon.common.item.CleavingAxeItem;
import elucent.eidolon.common.item.CodexItem;
import elucent.eidolon.common.item.ReaperScytheItem;
import elucent.eidolon.common.item.SummoningStaffItem;
import elucent.eidolon.common.item.WarlockRobesItem;
import elucent.eidolon.common.tile.GobletTileEntity;
import elucent.eidolon.network.CrystallizeEffectPacket;
import elucent.eidolon.network.KnowledgeUpdatePacket;
import elucent.eidolon.network.Networking;
import elucent.eidolon.network.SoulUpdatePacket;
import elucent.eidolon.network.WingsDataUpdatePacket;
import elucent.eidolon.registries.EidolonAttributes;
import elucent.eidolon.registries.EidolonPotions;
import elucent.eidolon.registries.Registry;
import elucent.eidolon.registries.Signs;
import elucent.eidolon.util.EntityUtil;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.hoglin.HoglinBase;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.Nullable;

public class Events {
    UUID etherealHealthUUID = UUID.fromString("e7d7b2d0-4b8a-11eb-ae93-0242ac130002");

    @SubscribeEvent
    public void attachWorldCaps(AttachCapabilitiesEvent<Level> event) {
        if (event.getObject() != null) {
            event.addCapability(new ResourceLocation("eidolon", "reputation"), (ICapabilityProvider)new IReputation.Provider());
        }
    }

    @SubscribeEvent
    public void attachEntityCaps(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(new ResourceLocation("eidolon", "knowledge"), (ICapabilityProvider)new IKnowledge.Provider());
            event.addCapability(new ResourceLocation("eidolon", "player_data"), (ICapabilityProvider)new IPlayerData.Provider());
            event.addCapability(new ResourceLocation("eidolon", "soul"), (ICapabilityProvider)new ISoul.Provider());
        }
    }

    @SubscribeEvent
    public void onClone(PlayerEvent.Clone event) {
        Capability<IKnowledge> KNOWLEDGE = IKnowledge.INSTANCE;
        Capability<ISoul> SOUL = ISoul.INSTANCE;
        Capability<IPlayerData> PDATA = IPlayerData.INSTANCE;
        event.getOriginal().reviveCaps();
        event.getEntity().getCapability(KNOWLEDGE).ifPresent(k -> event.getOriginal().getCapability(KNOWLEDGE).ifPresent(o -> ((INBTSerializable)k).deserializeNBT((Tag)((CompoundTag)((INBTSerializable)o).serializeNBT()))));
        event.getEntity().getCapability(SOUL).ifPresent(k -> event.getOriginal().getCapability(SOUL).ifPresent(o -> ((INBTSerializable)k).deserializeNBT((Tag)((CompoundTag)((INBTSerializable)o).serializeNBT()))));
        event.getEntity().getCapability(PDATA).ifPresent(k -> event.getOriginal().getCapability(PDATA).ifPresent(o -> ((INBTSerializable)k).deserializeNBT((Tag)((CompoundTag)((INBTSerializable)o).serializeNBT()))));
        event.getOriginal().invalidateCaps();
        if (!event.getEntity().f_19853_.f_46443_) {
            Networking.sendTo(event.getEntity(), new KnowledgeUpdatePacket(event.getEntity(), false));
            Networking.sendTo(event.getEntity(), new SoulUpdatePacket(event.getEntity()));
        }
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        KnowledgeCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ReputationCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onTarget(LivingChangeTargetEvent event) {
        if (event.getEntity() == null || !EntityUtil.isEnthralled(event.getEntity())) {
            return;
        }
        UUID master = event.getEntity().getPersistentData().m_128342_("eidolon:thrall");
        LivingEntity newTarget = null;
        if (EntityUtil.isEnthralledBy(event.getEntity(), event.getOriginalTarget())) {
            LivingEntity lastHurt = event.getOriginalTarget().m_21214_();
            LivingEntity lastHurtBy = event.getOriginalTarget().m_21188_();
            newTarget = Events.handleEnthralledTargeting(lastHurt, lastHurtBy, event.getEntity());
        } else {
            ServerLevel server;
            Level lastHurt = event.getEntity().m_9236_();
            if (lastHurt instanceof ServerLevel && (lastHurt = (server = (ServerLevel)lastHurt).m_8791_(master)) instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)lastHurt;
                lastHurt = living.m_21214_();
                LivingEntity lastHurtBy = living.m_21188_();
                newTarget = Events.handleEnthralledTargeting((LivingEntity)lastHurt, lastHurtBy, event.getEntity());
            }
        }
        if (!(event.getEntity() instanceof HoglinBase) || newTarget != null) {
            event.setNewTarget(newTarget);
        }
    }

    @Nullable
    public static LivingEntity handleEnthralledTargeting(@Nullable LivingEntity lastHurt, @Nullable LivingEntity lastHurtBy, LivingEntity thrall) {
        if (lastHurtBy != null && lastHurtBy != thrall && !thrall.m_7307_((Entity)lastHurtBy)) {
            return lastHurtBy;
        }
        if (lastHurt != null && lastHurt != thrall && !thrall.m_7307_((Entity)lastHurt)) {
            return lastHurt;
        }
        if (thrall.m_21188_() != null && !thrall.m_7307_((Entity)thrall.m_21188_())) {
            return thrall.m_21188_();
        }
        return null;
    }

    @SubscribeEvent
    public void onTick(LivingEvent.LivingTickEvent event) {
        Level level = event.getEntity().m_9236_();
        LivingEntity e = event.getEntity();
        if (e.m_21023_((MobEffect)EidolonPotions.UNDEATH_EFFECT.get()) && level.m_46461_() && !level.f_46443_) {
            BlockPos blockpos;
            float f = e.m_213856_();
            BlockPos blockPos = blockpos = e.m_20202_() instanceof Boat ? BlockPos.m_274561_((double)e.m_20185_(), (double)Math.round(e.m_20186_()), (double)e.m_20189_()).m_7494_() : BlockPos.m_274561_((double)e.m_20185_(), (double)Math.round(e.m_20186_()), (double)e.m_20189_());
            if (f > 0.5f && e.m_217043_().m_188501_() * 30.0f < (f - 0.4f) * 2.0f && level.m_45527_(blockpos)) {
                e.m_20254_(8);
            }
        }
        boolean hasBoneArmor = false;
        for (ItemStack s2 : e.m_6168_()) {
            if (!(s2.m_41720_() instanceof BonelordArmorItem)) continue;
            hasBoneArmor = true;
        }
        if (hasBoneArmor && (double)event.getEntity().m_21223_() >= (double)event.getEntity().m_21233_() * 0.999 && event.getEntity().f_19797_ % 80 == 0) {
            event.getEntity().getCapability(ISoul.INSTANCE).ifPresent(s -> s.healEtherealHealth(1.0f, ISoul.getPersistentHealth(event.getEntity())));
        }
    }

    @SubscribeEvent
    public void onDeath(LivingDropsEvent event) {
        Entity item2;
        BlockPos pos;
        Level world;
        List<GobletTileEntity> goblets;
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof Monster) && !(goblets = Ritual.getTilesWithinAABB(GobletTileEntity.class, world = entity.f_19853_, new AABB((pos = entity.m_20183_()).m_7918_(-2, -2, -2), pos.m_7918_(3, 3, 3)))).isEmpty()) {
            GobletTileEntity goblet = goblets.stream().min(Comparator.comparingDouble(g -> g.m_58899_().m_123331_((Vec3i)pos))).get();
            goblet.setEntityType(entity.m_6095_());
        }
        if (event.getSource().m_7639_() instanceof Player && !entity.f_19853_.m_5776_()) {
            Calendar calendar = Calendar.getInstance();
            int month = calendar.get(2) + 1;
            int day = calendar.get(5);
            if ((month == 10 && day >= 28 || month == 11 && day <= 2) && entity.f_19853_.f_46441_.m_188503_(10) == 0) {
                if (entity instanceof Zombie) {
                    event.getDrops().add(new ItemEntity(entity.f_19853_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), new ItemStack((ItemLike)Registry.RED_CANDY.get())));
                } else if (entity instanceof AbstractSkeleton) {
                    event.getDrops().add(new ItemEntity(entity.f_19853_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), new ItemStack((ItemLike)Registry.GRAPE_CANDY.get())));
                }
            }
        }
        if ((entity instanceof Witch || entity instanceof Villager) && entity.m_21205_().m_41720_() instanceof CodexItem) {
            event.getDrops().add(new ItemEntity(entity.f_19853_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity.m_21205_().m_41777_()));
        }
        if (entity instanceof ZombieBruteEntity && (entity.m_21023_(MobEffects.f_19615_) || event.getSource().m_276093_(DamageTypes.f_268493_)) && !entity.f_19853_.f_46443_) {
            for (Entity item2 : event.getDrops()) {
                if (!item2.m_32055_().m_150930_((Item)Registry.ZOMBIE_HEART.get())) continue;
                item2.m_32045_(new ItemStack((ItemLike)Registry.WITHERED_HEART.get(), item2.m_32055_().m_41613_()));
            }
        }
        if (event.getSource().m_7639_() != null && (item2 = event.getSource().m_7639_()) instanceof LivingEntity) {
            LivingEntity source = (LivingEntity)item2;
            ItemStack held = source.m_21205_();
            if (!entity.f_19853_.f_46443_ && (held.m_41720_() instanceof ReaperScytheItem || event.getSource().m_276093_(Registry.RITUAL_DAMAGE.key)) && entity.m_21222_()) {
                if (!(entity instanceof Player)) {
                    event.getDrops().clear();
                }
                int looting = ForgeHooks.getLootingLevel((Entity)entity, (Entity)source, (DamageSource)event.getSource());
                ItemEntity drop = new ItemEntity(source.f_19853_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), new ItemStack((ItemLike)Registry.SOUL_SHARD.get(), source.f_19853_.f_46441_.m_188503_(2 + looting)));
                drop.m_32060_();
                event.getDrops().add(drop);
                Networking.sendToTracking(entity.f_19853_, entity.m_20183_(), new CrystallizeEffectPacket(entity.m_20183_()));
            }
            if (!entity.f_19853_.f_46443_ && held.m_41720_() instanceof CleavingAxeItem) {
                int looting = ForgeHooks.getLootingLevel((Entity)entity, (Entity)source, (DamageSource)event.getSource());
                Events.beheading(event, source, entity, looting);
            }
        }
    }

    private static void beheading(LivingDropsEvent event, LivingEntity source, LivingEntity entity, int looting) {
        ItemStack head = ItemStack.f_41583_;
        if (entity instanceof WitherSkeleton) {
            head = new ItemStack((ItemLike)Items.f_42679_);
        } else if (entity instanceof Skeleton) {
            head = new ItemStack((ItemLike)Items.f_42678_);
        } else if (entity instanceof Zombie) {
            head = new ItemStack((ItemLike)Items.f_42681_);
        } else if (entity instanceof Creeper) {
            head = new ItemStack((ItemLike)Items.f_42682_);
        } else if (entity instanceof EnderDragon) {
            head = new ItemStack((ItemLike)Items.f_42683_);
        } else if (entity instanceof Player) {
            head = new ItemStack((ItemLike)Items.f_42680_);
            GameProfile gameprofile = ((Player)entity).m_36316_();
            head.m_41784_().m_128365_("SkullOwner", (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)gameprofile));
        }
        if (!head.m_41619_()) {
            boolean doDrop = false;
            if (entity.f_19853_.f_46441_.m_188503_(20) == 0) {
                doDrop = true;
            } else {
                for (int i = 0; i < looting; ++i) {
                    if (entity.f_19853_.f_46441_.m_188503_(40) != 0) continue;
                    doDrop = true;
                    break;
                }
            }
            for (ItemEntity e : event.getDrops()) {
                if (!e.m_32055_().m_150930_(head.m_41720_())) continue;
                doDrop = false;
            }
            if (doDrop) {
                ItemEntity drop = new ItemEntity(source.f_19853_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), head);
                drop.m_32060_();
                event.getDrops().add(drop);
            }
        }
    }

    @SubscribeEvent
    public void registerCustomAI(EntityJoinLevelEvent event) {
        if (event.getEntity() instanceof LivingEntity && !event.getLevel().f_46443_) {
            PathfinderMob mob;
            Entity entity = event.getEntity();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                Networking.sendTo(player, new KnowledgeUpdatePacket(player, false));
                Networking.sendTo(player, new SoulUpdatePacket(player));
            }
            if ((entity = event.getEntity()) instanceof Witch) {
                Witch witch = (Witch)entity;
                witch.f_21345_.m_25352_(1, (Goal)new WitchBarterGoal(witch, stack -> stack.m_41720_() == Registry.CODEX.get(), stack -> CodexItem.withSign(stack, Signs.WICKED_SIGN)));
            }
            if ((entity = event.getEntity()) instanceof Villager) {
                Villager villager = (Villager)entity;
                villager.f_21345_.m_25352_(1, (Goal)new PriestBarterGoal(villager, stack -> stack.m_41720_() == Registry.CODEX.get(), stack -> CodexItem.withSign(stack, Signs.SACRED_SIGN)));
            }
            if ((entity = event.getEntity()) instanceof PathfinderMob && Eidolon.getTrueMobType((LivingEntity)(mob = (PathfinderMob)entity)) == MobType.f_21641_ && (mob.m_21573_() instanceof GroundPathNavigation || mob.m_21573_() instanceof FlyingPathNavigation)) {
                mob.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal(mob, LivingEntity.class, 6.0f, 1.0, 1.2, living -> !EntityUtil.isEnthralled((LivingEntity)mob) && living.m_21023_((MobEffect)EidolonPotions.LIGHT_BLESSED.get())));
                try {
                    mob.f_21345_.m_25352_(2, (Goal)new FollowOwnerGoal((Mob)mob, 1.5, 3.0f, 1.2f));
                    mob.f_21346_.m_25352_(1, (Goal)new ThrallTargetGoal(mob));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            event.player.getCapability(IPlayerData.INSTANCE).ifPresent(d -> {
                if (!d.getWingsItem(event.player).m_41619_()) {
                    if (event.player.m_6047_() && event.player.m_20184_().f_82480_ < -0.1) {
                        d.startFlying(event.player);
                        event.player.m_20334_(event.player.m_20184_().f_82479_, -0.1, event.player.m_20184_().f_82481_);
                    }
                    if (d.isFlying(event.player)) {
                        event.player.m_183634_();
                    }
                    if (d.isDashing(event.player)) {
                        d.doDashTick(event.player);
                    }
                    if (event.player.m_20096_()) {
                        d.rechargeWings(event.player);
                        d.stopFlying(event.player);
                    }
                    if (!event.player.f_19853_.f_46443_) {
                        Networking.sendToTracking(event.player.f_19853_, event.player.m_20183_(), new WingsDataUpdatePacket(event.player));
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public void onApplyPotion(MobEffectEvent.Applicable event) {
        if (event.getEffectInstance().m_19544_() == MobEffects.f_19597_ && event.getEntity().m_6844_(EquipmentSlot.FEET).m_41720_() instanceof WarlockRobesItem) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onLivingUse(LivingEntityUseItemEvent.Start event) {
        if (event.getEntity().m_21023_((MobEffect)EidolonPotions.UNDEATH_EFFECT.get()) && event.getItem().m_41614_() && !event.getItem().m_204117_(Registry.ZOMBIE_FOOD_TAG)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    @Deprecated
    public void onPotionApplicable(MobEffectEvent.Added event) {
        if (event.getEntity().m_21023_(MobEffects.f_19612_) && event.getEffectInstance().m_19544_() == EidolonPotions.UNDEATH_EFFECT.get()) {
            event.getEntity().m_21195_(MobEffects.f_19612_);
        }
    }

    @SubscribeEvent
    public void onPotionApplicable(MobEffectEvent.Applicable event) {
        if (event.getEntity().m_21023_((MobEffect)EidolonPotions.UNDEATH_EFFECT.get()) && event.getEffectInstance().m_19544_() == MobEffects.f_19612_) {
            event.setResult(Event.Result.DENY);
        }
        if (event.getEntity().m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof BonelordArmorItem && (event.getEffectInstance().m_19544_() == MobEffects.f_19615_ || event.getEffectInstance().m_19544_() == MobEffects.f_19614_)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        LivingEntity living;
        AttributeInstance attribute;
        Entity entity;
        boolean isMagic = event.getSource().m_269533_(Registry.FORGE_MAGIC);
        boolean isWither = event.getSource().m_19385_().equals(event.getEntity().m_269291_().m_269251_().m_19385_());
        if (isMagic && (entity = event.getSource().m_7639_()) instanceof LivingEntity && (attribute = (living = (LivingEntity)entity).m_21051_((Attribute)EidolonAttributes.MAGIC_POWER.get())) != null) {
            event.setAmount(event.getAmount() * (float)attribute.m_22135_());
        }
        if (isWither && (entity = event.getSource().m_7639_()) instanceof LivingEntity && (living = (LivingEntity)entity).m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof WarlockRobesItem) {
            event.setAmount(event.getAmount() * 1.5f);
            living.m_5634_(event.getAmount() / 2.0f);
        }
        if ((isMagic || isWither) && event.getEntity().m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof WarlockRobesItem) {
            event.setAmount(event.getAmount() / 2.0f);
        }
        event.getEntity().getCapability(ISoul.INSTANCE).ifPresent(s -> {
            if (s.hasEtherealHealth()) {
                float reduced = s.hurtEtherealHealth(event.getAmount(), ISoul.getPersistentHealth(event.getEntity()));
                event.setAmount(reduced);
                Networking.sendToTracking(event.getEntity().f_19853_, event.getEntity().m_20097_(), new SoulUpdatePacket((Player)event.getEntity()));
            }
        });
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity source = (LivingEntity)entity;
            if (EntityUtil.isEnthralledBy(event.getEntity(), source)) {
                Item item = source.m_21205_().m_41720_();
                if (item instanceof SummoningStaffItem) {
                    SummoningStaffItem summoningStaffItem = (SummoningStaffItem)item;
                    CompoundTag eTag = event.getEntity().serializeNBT();
                    event.getEntity().m_142687_(Entity.RemovalReason.KILLED);
                    summoningStaffItem.addCharge(source.m_21205_(), eTag);
                    event.setCanceled(true);
                }
            } else if (EntityUtil.isEnthralledBy(source, event.getEntity())) {
                event.setCanceled(true);
            } else if (EntityUtil.sameMaster(event.getEntity(), source)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player;
        AttributeInstance attr;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && (attr = (player = (ServerPlayer)player2).m_21051_((Attribute)EidolonAttributes.MAX_SOUL_HEARTS.get())) != null && attr.m_22111_(this.etherealHealthUUID) == null) {
            attr.m_22125_(new AttributeModifier(this.etherealHealthUUID, "eidolon:configured_max_ethereal", (double)((Integer)Config.MAX_ETHEREAL_HEALTH.get()).intValue(), AttributeModifier.Operation.ADDITION));
        }
    }
}

