/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.tile;

import elucent.eidolon.Eidolon;
import elucent.eidolon.api.altar.AltarInfo;
import elucent.eidolon.api.deity.Deity;
import elucent.eidolon.api.ritual.Ritual;
import elucent.eidolon.capability.IReputation;
import elucent.eidolon.client.particle.Particles;
import elucent.eidolon.common.deity.Deities;
import elucent.eidolon.common.deity.DeityLocks;
import elucent.eidolon.common.spell.PrayerSpell;
import elucent.eidolon.common.tile.EffigyTileEntity;
import elucent.eidolon.common.tile.IBurner;
import elucent.eidolon.common.tile.TileEntityBase;
import elucent.eidolon.network.ExtinguishEffectPacket;
import elucent.eidolon.network.Networking;
import elucent.eidolon.registries.EidolonParticles;
import elucent.eidolon.registries.Registry;
import elucent.eidolon.util.KnowledgeUtil;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class CenserTileEntity
extends TileEntityBase
implements IBurner {
    ItemStack incense = ItemStack.f_41583_;
    boolean isBurning;
    int burnCounter;

    public CenserTileEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public CenserTileEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)Registry.CENSER_TILE_ENTITY.get(), pos, state);
    }

    @Override
    public boolean canStartBurning() {
        return !this.isBurning && !this.incense.m_41619_();
    }

    public void tick() {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.f_46443_ && this.isBurning) {
            ++this.burnCounter;
            if (this.burnCounter >= 400 && this.incense.m_41619_()) {
                this.isBurning = false;
                this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(this.isBurning)));
                this.burnCounter = 0;
                Networking.sendToTracking(this.f_58857_, this.f_58858_, new ExtinguishEffectPacket(this.f_58858_));
            }
            this.sync();
        }
        if (this.burnCounter == 80) {
            this.incense = ItemStack.f_41583_;
        }
        if (this.f_58857_.f_46443_ && this.isBurning) {
            float x = (float)this.m_58899_().m_123341_() + 0.5f;
            float y = (float)this.m_58899_().m_123342_() + 0.45f;
            float z = (float)this.m_58899_().m_123343_() + 0.5f;
            float r = 1.0f;
            float g = 0.5f;
            float b = 0.25f;
            if (this.burnCounter < 160) {
                Particles.create(EidolonParticles.FLAME_PARTICLE).setAlpha(0.5f, 0.0f).setScale(0.25f, 0.125f).setLifetime(20).randomOffset(0.125, 0.125).randomVelocity(0.00625f, 0.01875f).addVelocity(0.0, 0.00625f, 0.0).setColor(r, g, b, r, g * 0.5f, b * 1.5f).spawn(this.f_58857_, x, y, z);
            }
            if (this.f_58857_.f_46441_.m_188503_(20) == 0) {
                Particles.create(EidolonParticles.SPARKLE_PARTICLE).setAlpha(1.0f, 0.0f).setScale(0.0625f, 0.0f).setLifetime(40).randomOffset(0.0625, 0.0).randomVelocity(0.125, 0.0).addVelocity(0.0, 0.125, 0.0).setColor(r, g * 1.5f, b * 2.0f, r, g, b).enableGravity().setSpin(0.4f).spawn(this.f_58857_, x, y, z);
            }
            if (this.f_58857_.f_46441_.m_188503_(5) == 0) {
                Particles.create(EidolonParticles.SMOKE_PARTICLE).setAlpha(0.25f, 0.0f).setScale(0.375f, 0.125f).setLifetime(160).randomOffset(0.25, 0.125).randomVelocity(0.025f, 0.025f).addVelocity(0.0, 0.0125f, 0.0).setColor(0.5f, 0.5f, 0.5f, 0.25f, 0.25f, 0.25f).spawn(this.f_58857_, x, (double)y + 0.125, z);
            }
        }
    }

    @Override
    public InteractionResult onActivated(BlockState state, BlockPos pos, Player player, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && this.f_58857_ instanceof ServerLevel && !this.isBurning) {
            ItemStack itemInHand = player.m_21120_(hand);
            if (itemInHand.m_41619_() && !this.incense.m_41619_()) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.incense);
                this.incense = ItemStack.f_41583_;
                if (!this.f_58857_.f_46443_) {
                    this.sync();
                }
                return InteractionResult.SUCCESS;
            }
            if (!itemInHand.m_41619_() && this.incense.m_41619_()) {
                if (itemInHand.m_41720_() == Registry.OFFERING_INCENSE.get()) {
                    this.incense = itemInHand.m_41620_(1);
                    if (!this.f_58857_.f_46443_) {
                        this.sync();
                    }
                    return InteractionResult.SUCCESS;
                }
            } else if (!itemInHand.m_41619_() && !this.incense.m_41619_()) {
                if (itemInHand.m_41720_() instanceof FlintAndSteelItem && !this.f_58857_.f_46443_ && this.canStartBurning()) {
                    this.startBurning(player, this.f_58857_, pos);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public void startBurning(Player player, @NotNull Level world, BlockPos pos) {
        if (!world.getCapability(IReputation.INSTANCE).isPresent()) {
            return;
        }
        if (!((IReputation)world.getCapability(IReputation.INSTANCE).resolve().get()).canPray(player, Eidolon.prefix("basic_incense"), world.m_46467_())) {
            player.m_5661_((Component)Component.m_237115_((String)"eidolon.message.prayer_cooldown"), true);
            return;
        }
        List<EffigyTileEntity> effigies = Ritual.getTilesWithinAABB(EffigyTileEntity.class, world, new AABB(pos.m_7918_(-4, -4, -4), pos.m_7918_(5, 5, 5)));
        if (effigies.isEmpty()) {
            return;
        }
        EffigyTileEntity effigy = effigies.stream().min(Comparator.comparingDouble(e -> e.m_58899_().m_123331_((Vec3i)pos))).get();
        if (effigy.ready()) {
            Deity deity = Deities.LIGHT_DEITY;
            AltarInfo info = AltarInfo.getAltarInfo(world, effigy.m_58899_());
            world.getCapability(IReputation.INSTANCE, null).ifPresent(rep -> {
                if (rep.getReputation(player, deity.getId()) < 3.0) {
                    player.m_5661_((Component)Component.m_237115_((String)"eidolon.message.not_enough_reputation"), true);
                    return;
                }
                KnowledgeUtil.grantResearchNoToast((Entity)player, DeityLocks.BASIC_INCENSE_PRAYER);
                rep.pray(player, Eidolon.prefix("basic_incense"), world.m_46467_());
                rep.addReputation(player, deity.getId(), 2.0 + 0.5 * info.getPower());
                PrayerSpell.updateMagic(info, player, world, rep.getReputation(player, deity.getId()));
            });
            this.isBurning = true;
            world.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(this.isBurning)));
            this.burnCounter = 0;
            this.sync();
        }
    }

    public void m_142466_(@NotNull CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("incense")) {
            this.incense = ItemStack.m_41712_((CompoundTag)pTag.m_128469_("incense"));
        }
        this.burnCounter = pTag.m_128451_("burnCounter");
        this.isBurning = pTag.m_128471_("isBurning");
    }

    protected void m_183515_(@NotNull CompoundTag pTag) {
        super.m_183515_(pTag);
        if (!this.incense.m_41619_()) {
            pTag.m_128365_("incense", (Tag)this.incense.m_41739_(new CompoundTag()));
        }
        pTag.m_128405_("burnCounter", this.burnCounter);
        pTag.m_128379_("isBurning", this.isBurning);
    }
}

