/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.item;

import elucent.eidolon.common.block.HerbBlockBase;
import elucent.eidolon.common.item.Tiers;
import elucent.eidolon.registries.Registry;
import elucent.eidolon.util.RegistryUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class AthameItem
extends SwordItem {
    String loreTag = null;
    public static final Map<ResourceLocation, ItemStack> harvestables = new HashMap<ResourceLocation, ItemStack>();

    public AthameItem(Item.Properties builderIn) {
        super((Tier)Tiers.PewterTier.INSTANCE, 1, -1.6f, builderIn);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onLooting(LootingLevelEvent event) {
        if (event.getEntity().m_21205_().m_41720_() instanceof AthameItem) {
            event.setLootingLevel(event.getLootingLevel() * 2 + 1);
        }
    }

    @SubscribeEvent
    public void onHurt(LivingHurtEvent event) {
        LivingEntity living;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21205_().m_41720_() instanceof AthameItem && (event.getEntity() instanceof EnderMan || event.getEntity() instanceof Endermite || event.getEntity() instanceof EnderDragon)) {
            event.setAmount(event.getAmount() * 4.0f);
        }
    }

    public Item setLore(String tag) {
        this.loreTag = tag;
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        if (this.loreTag != null) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.DARK_PURPLE) + ChatFormatting.ITALIC + I18n.m_118938_((String)this.loreTag, (Object[])new Object[0]))));
        }
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext ctx) {
        BlockState state = ctx.m_43725_().m_8055_(ctx.m_8083_());
        RandomSource random = ctx.m_43723_() != null ? ctx.m_43723_().m_217043_() : ctx.m_43725_().m_213780_();
        float hardness = state.m_60800_((BlockGetter)ctx.m_43725_(), ctx.m_8083_());
        Block block = state.m_60734_();
        if ((block instanceof BushBlock || block instanceof LeavesBlock || state.m_204336_(BlockTags.f_13035_) || state.m_204336_(BlockTags.f_13073_) || state.m_204336_(BlockTags.f_13041_) || block instanceof GrowingPlantBlock || block instanceof HerbBlockBase) && hardness < 5.0f && hardness >= 0.0f) {
            if (!ctx.m_43725_().f_46443_) {
                Vec3 hit = ctx.m_43720_();
                ((ServerLevel)ctx.m_43725_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), hit.f_82479_, hit.f_82480_, hit.f_82481_, 3, ((double)random.m_188501_() - 0.5) * 0.08, ((double)random.m_188501_() - 0.5) * 0.08, ((double)random.m_188501_() - 0.5) * 0.08, (double)0.05f);
                ctx.m_43725_().m_5594_(null, ctx.m_8083_(), SoundEvents.f_12344_, SoundSource.PLAYERS, 0.5f, 0.9f + random.m_188501_() * 0.2f);
                if (random.m_188503_(5) == 0) {
                    if (state.m_204336_(Registry.PLANTER_PLANTS)) {
                        if ((Integer)state.m_61143_((Property)HerbBlockBase.AGE) == 2) {
                            ctx.m_43725_().m_46597_(ctx.m_8083_(), (BlockState)state.m_61124_((Property)HerbBlockBase.AGE, (Comparable)Integer.valueOf(0)));
                            ItemStack drop = AthameItem.getHarvestable(state);
                            if (!drop.m_41619_() && !ctx.m_43725_().f_46443_) {
                                ctx.m_43725_().m_5594_(null, ctx.m_8083_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.5f, 0.9f + random.m_188501_() * 0.2f);
                                for (int i = -1; i < random.m_188503_(3); ++i) {
                                    ctx.m_43725_().m_7967_((Entity)new ItemEntity(ctx.m_43725_(), (double)ctx.m_8083_().m_123341_() + 0.5, (double)ctx.m_8083_().m_123342_() + 0.5, (double)ctx.m_8083_().m_123343_() + 0.5, drop.m_41777_()));
                                }
                            }
                            if (!ctx.m_43723_().m_7500_()) {
                                ctx.m_43722_().m_41622_(1, (LivingEntity)ctx.m_43723_(), player -> player.m_21190_(ctx.m_43724_()));
                            }
                        }
                    } else {
                        if (state.m_60734_() instanceof DoublePlantBlock && state.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.UPPER) {
                            ctx.m_43725_().m_46961_(ctx.m_8083_().m_7495_(), false);
                        } else {
                            ctx.m_43725_().m_46961_(ctx.m_8083_(), false);
                        }
                        if (random.m_188503_(6) == 0) {
                            ItemStack drop = AthameItem.getHarvestable(state);
                            if (!drop.m_41619_() && !ctx.m_43725_().f_46443_) {
                                ctx.m_43725_().m_5594_(null, ctx.m_8083_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.5f, 0.9f + random.m_188501_() * 0.2f);
                                ctx.m_43725_().m_7967_((Entity)new ItemEntity(ctx.m_43725_(), (double)ctx.m_8083_().m_123341_() + 0.5, (double)ctx.m_8083_().m_123342_() + 0.5, (double)ctx.m_8083_().m_123343_() + 0.5, drop.m_41777_()));
                            }
                            if (!ctx.m_43723_().m_7500_()) {
                                ctx.m_43722_().m_41622_(1, (LivingEntity)ctx.m_43723_(), player -> player.m_21190_(ctx.m_43724_()));
                            }
                        }
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(ctx);
    }

    public static void initHarvestables() {
        harvestables.put(RegistryUtil.getRegistryName(Blocks.f_50053_), new ItemStack((ItemLike)Registry.SILDRIAN_SEED.get()));
        harvestables.put(RegistryUtil.getRegistryName(Blocks.f_50196_), new ItemStack((ItemLike)Registry.OANNA_BLOOM.get()));
        harvestables.put(RegistryUtil.getRegistryName(Blocks.f_50120_), new ItemStack((ItemLike)Registry.MERAMMER_ROOT.get()));
        harvestables.put(RegistryUtil.getRegistryName(Blocks.f_50071_), new ItemStack((ItemLike)Registry.MERAMMER_ROOT.get()));
        harvestables.put(RegistryUtil.getRegistryName(Blocks.f_50118_), new ItemStack((ItemLike)Registry.MERAMMER_ROOT.get()));
        harvestables.put(RegistryUtil.getRegistryName(Blocks.f_50035_), new ItemStack((ItemLike)Registry.AVENNIAN_SPRIG.get()));
        harvestables.put(RegistryUtil.getRegistryName((Block)Registry.MERAMMER_ROOT.get()), new ItemStack((ItemLike)Registry.MERAMMER_ROOT.get()));
        harvestables.put(RegistryUtil.getRegistryName((Block)Registry.OANNA_BLOOM.get()), new ItemStack((ItemLike)Registry.OANNA_BLOOM.get()));
        harvestables.put(RegistryUtil.getRegistryName((Block)Registry.SILDRIAN_SEED.get()), new ItemStack((ItemLike)Registry.SILDRIAN_SEED.get()));
        harvestables.put(RegistryUtil.getRegistryName((Block)Registry.AVENNIAN_SPRIG.get()), new ItemStack((ItemLike)Registry.AVENNIAN_SPRIG.get()));
    }

    public static ItemStack getHarvestable(BlockState state) {
        return harvestables.getOrDefault(RegistryUtil.getRegistryName(state.m_60734_()), ItemStack.f_41583_);
    }
}

