/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.entity;

import elucent.eidolon.util.EntityUtil;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpellProjectileEntity
extends Entity {
    public static final TagKey<EntityType<?>> TRACKABLE = TagKey.m_203882_((ResourceKey)ForgeRegistries.ENTITY_TYPES.getRegistryKey(), (ResourceLocation)new ResourceLocation("eidolon", "trackable"));
    public static final TagKey<EntityType<?>> TRACKABLE_BLACKLIST = TagKey.m_203882_((ResourceKey)ForgeRegistries.ENTITY_TYPES.getRegistryKey(), (ResourceLocation)new ResourceLocation("eidolon", "trackable_blacklist"));
    public Predicate<Entity> trackingPredicate = this::shouldTrack;
    public boolean isTracking;
    public boolean noImmunityFrame;
    protected UUID casterId = null;
    private final Predicate<Entity> impactPredicate = this::shouldImpact;

    public SpellProjectileEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public Entity shoot(double x, double y, double z, double vx, double vy, double vz, UUID caster, ItemStack stack) {
        this.m_6034_(x, y, z);
        this.m_20334_(vx, vy, vz);
        this.casterId = caster;
        this.f_19864_ = true;
        return this;
    }

    private boolean shouldImpact(Entity target) {
        if (!target.m_5833_() && target.m_6087_() && !target.m_20148_().equals(this.casterId)) {
            return true;
        }
        return this.shouldTrack(target);
    }

    private boolean shouldTrack(Entity target) {
        return !target.m_5833_() && !target.m_20148_().equals(this.casterId) && !target.m_6095_().m_204039_(TRACKABLE_BLACKLIST) && (target instanceof Enemy || target.m_6095_().m_204039_(TRACKABLE));
    }

    public void m_8119_() {
        if (this.isTracking) {
            EntityUtil.moveTowardsTarget(this);
        }
        Vec3 motion = this.m_20184_();
        this.m_20334_(motion.f_82479_ * 0.96, (motion.f_82480_ > 0.0 ? motion.f_82480_ * 0.96 : motion.f_82480_) - (double)0.03f, motion.f_82481_ * 0.96);
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            HitResult ray = ProjectileUtil.m_278158_((Entity)this, this.impactPredicate);
            if (ray.m_6662_() == HitResult.Type.ENTITY) {
                this.onImpact(ray, ((EntityHitResult)ray).m_82443_());
            } else if (ray.m_6662_() == HitResult.Type.BLOCK) {
                this.onImpact(ray);
            }
        }
        Vec3 pos = this.m_20182_();
        this.f_19854_ = pos.f_82479_;
        this.f_19855_ = pos.f_82480_;
        this.f_19856_ = pos.f_82481_;
        this.m_6034_(pos.f_82479_ + motion.f_82479_, pos.f_82480_ + motion.f_82480_, pos.f_82481_ + motion.f_82481_);
    }

    public UUID getCasterId() {
        return this.casterId;
    }

    protected abstract void onImpact(HitResult var1, Entity var2);

    protected abstract void onImpact(HitResult var1);

    protected void handleSpellDamage(Entity caster, Entity target, DamageSource damageSource, float rawDamage) {
        int prevHurtResist = target.f_19802_;
        if (this.noImmunityFrame) {
            target.f_19802_ = 0;
        }
        target.m_6469_(damageSource, rawDamage);
        if (this.noImmunityFrame) {
            target.f_19802_ = prevHurtResist;
        }
    }

    @Nullable
    public Player getCaster() {
        return this.f_19853_.m_46003_(this.casterId);
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compound) {
        this.casterId = compound.m_128441_("caster") ? compound.m_128342_("caster") : null;
    }

    protected void m_7380_(@NotNull CompoundTag compound) {
        if (this.casterId != null) {
            compound.m_128362_("caster", this.casterId);
        }
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

