/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.entity;

import elucent.eidolon.client.particle.Particles;
import elucent.eidolon.common.entity.SpellProjectileEntity;
import elucent.eidolon.network.MagicBurstEffectPacket;
import elucent.eidolon.network.Networking;
import elucent.eidolon.registries.EidolonEntities;
import elucent.eidolon.registries.EidolonParticles;
import elucent.eidolon.registries.EidolonPotions;
import elucent.eidolon.util.ColorUtil;
import elucent.eidolon.util.DamageTypeData;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class NecromancerSpellEntity
extends SpellProjectileEntity {
    public static final EntityDataAccessor<Integer> DELAY = SynchedEntityData.m_135353_(NecromancerSpellEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public NecromancerSpellEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.m_20088_().m_135372_(DELAY, (Object)0);
    }

    public NecromancerSpellEntity(Level worldIn, double x, double y, double z, double vx, double vy, double vz, int delay) {
        super((EntityType)EidolonEntities.NECROMANCER_SPELL.get(), worldIn);
        this.m_6034_(x, y, z);
        this.m_20334_(vx, vy, vz);
        this.m_20088_().m_135372_(DELAY, (Object)delay);
    }

    @Override
    public void m_8119_() {
        if ((Integer)this.m_20088_().m_135370_(DELAY) > 0) {
            this.m_20088_().m_135381_(DELAY, (Object)((Integer)this.m_20088_().m_135370_(DELAY) - 1));
            return;
        }
        super.m_8119_();
        Vec3 motion = this.m_20184_();
        Vec3 pos = this.m_20182_();
        Vec3 norm = motion.m_82541_().m_82490_((double)0.025f);
        for (int i = 0; i < 8; ++i) {
            double lerpX = Mth.m_14139_((double)((float)i / 8.0f), (double)this.f_19854_, (double)pos.f_82479_);
            double lerpY = Mth.m_14139_((double)((float)i / 8.0f), (double)this.f_19855_, (double)pos.f_82480_);
            double lerpZ = Mth.m_14139_((double)((float)i / 8.0f), (double)this.f_19856_, (double)pos.f_82481_);
            Particles.create(EidolonParticles.WISP_PARTICLE).addVelocity(-norm.f_82479_, -norm.f_82480_, -norm.f_82481_).setAlpha(0.375f, 0.0f).setScale(0.25f, 0.0f).setColor(1.0f, 0.3125f, 0.375f, 0.75f, 0.375f, 1.0f).setLifetime(5).spawn(this.f_19853_, lerpX, lerpY, lerpZ);
            Particles.create(EidolonParticles.SMOKE_PARTICLE).addVelocity(-norm.f_82479_, -norm.f_82480_, -norm.f_82481_).setAlpha(0.0625f, 0.0f).setScale(0.3125f, 0.125f).setColor(0.625f, 0.375f, 1.0f, 0.25f, 0.25f, 0.75f).randomVelocity(0.025f, 0.025f).setLifetime(20).spawn(this.f_19853_, lerpX, lerpY, lerpZ);
        }
    }

    @Override
    protected void onImpact(HitResult ray, Entity target) {
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            living.m_7292_(new MobEffectInstance((MobEffect)EidolonPotions.VULNERABLE_EFFECT.get(), 100));
        }
        Entity caster = this.f_19853_.m_6815_((int)this.casterId.getLeastSignificantBits());
        this.handleSpellDamage(caster, target, DamageTypeData.source((LevelAccessor)target.m_9236_(), (ResourceKey<DamageType>)DamageTypes.f_268493_, this, caster), 3 + this.f_19853_.m_46791_().m_19028_());
        this.onImpact(ray);
    }

    @Override
    protected void onImpact(HitResult ray) {
        this.m_6089_();
        if (!this.f_19853_.f_46443_) {
            Vec3 pos = ray.m_82450_();
            this.f_19853_.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_12558_, SoundSource.HOSTILE, 0.5f, this.f_19796_.m_188501_() * 0.2f + 0.9f);
            Networking.sendToTracking(this.f_19853_, this.m_20183_(), new MagicBurstEffectPacket(pos.f_82479_, pos.f_82480_, pos.f_82481_, ColorUtil.packColor(255, 158, 92, 255), ColorUtil.packColor(255, 60, 62, 186)));
        }
    }
}

