/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.block;

import elucent.eidolon.common.block.BlockBase;
import elucent.eidolon.registries.Registry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;

public class PillarBlockBase
extends BlockBase
implements SimpleWaterloggedBlock {
    public static final BooleanProperty TOP = BooleanProperty.m_61465_((String)"top");
    public static final BooleanProperty BOTTOM = BooleanProperty.m_61465_((String)"bottom");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public PillarBlockBase(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected boolean canConnectTo(LevelAccessor world, BlockPos pos, Direction dir) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() instanceof PillarBlockBase && dir.m_122434_() == Direction.Axis.Y) {
            return true;
        }
        return dir == Direction.UP && state.m_60734_() == Registry.STONE_HAND.get();
    }

    protected BlockState getState(Level world, BlockPos pos) {
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)TOP, (Comparable)Boolean.valueOf(this.canConnectTo((LevelAccessor)world, pos.m_7494_(), Direction.UP)))).m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(this.canConnectTo((LevelAccessor)world, pos.m_7495_(), Direction.DOWN)))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.m_6425_(pos).m_76152_() == Fluids.f_76193_));
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7420_(BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getState(context.m_43725_(), context.m_8083_());
    }

    @NotNull
    public BlockState m_7417_(BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        if (facing == Direction.UP) {
            state = (BlockState)state.m_61124_((Property)TOP, (Comparable)Boolean.valueOf(this.canConnectTo(world, pos.m_7494_(), Direction.UP)));
        }
        if (facing == Direction.DOWN) {
            state = (BlockState)state.m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(this.canConnectTo(world, pos.m_7495_(), Direction.DOWN)));
        }
        return state;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TOP, BOTTOM, WATERLOGGED});
    }
}

