/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static ForgeConfigSpec.ConfigValue<Integer> CRUCIBLE_STEP_DURATION;
    public static ForgeConfigSpec.ConfigValue<Integer> MAX_ETHEREAL_HEALTH;
    public static ForgeConfigSpec.ConfigValue<Integer> SOUL_ENCHANTER_MAXIMUM_USES;
    public static ForgeConfigSpec.ConfigValue<Integer> SOUL_ENCHANTER_MAXIMUM_ENCHANTMENTS;
    public static final Config INSTANCE;
    public static final ForgeConfigSpec SPEC;

    public Config(ForgeConfigSpec.Builder builder) {
        builder.comment("Generic settings").push("generic");
        CRUCIBLE_STEP_DURATION = builder.comment("Duration in ticks of each step of a crucible recipe.").defineInRange("crucibleStepDuration", 100, 20, 1200);
        MAX_ETHEREAL_HEALTH = builder.comment("Maximum amount of ethereal health (soul half-hearts) an entity can have at once.").defineInRange("maxEtherealHealth", 80, 0, 1000);
        builder.pop();
        builder.comment("Soul Enchanter").push("soulEnchanter");
        SOUL_ENCHANTER_MAXIMUM_USES = builder.comment("How often the Soul Enchanter can apply enchantments on an item (a value below 0 means unlimited)").define("soulEnchanterMaximumUses", (Object)-1);
        SOUL_ENCHANTER_MAXIMUM_ENCHANTMENTS = builder.comment("How many enchantments the item is allowed to have to be applicable for soul enchanting (a value below 0 means unlimited)").define("soulEnchanterMaximumEnchantments", (Object)-1);
        builder.pop();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        SPEC = (ForgeConfigSpec)specPair.getRight();
        INSTANCE = (Config)specPair.getLeft();
    }
}

