/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.registries;

import elucent.eidolon.api.spells.SignSequence;
import elucent.eidolon.api.spells.Spell;
import elucent.eidolon.common.deity.Deities;
import elucent.eidolon.common.spell.AnimalSacrificeSpell;
import elucent.eidolon.common.spell.ConvertZombieSpell;
import elucent.eidolon.common.spell.DarkTouchSpell;
import elucent.eidolon.common.spell.FireTouchSpell;
import elucent.eidolon.common.spell.FrostSpell;
import elucent.eidolon.common.spell.HealSpell;
import elucent.eidolon.common.spell.LightArmorSpell;
import elucent.eidolon.common.spell.LightSpell;
import elucent.eidolon.common.spell.LightTouchSpell;
import elucent.eidolon.common.spell.PrayerSpell;
import elucent.eidolon.common.spell.SmiteSpell;
import elucent.eidolon.common.spell.SunderArmorSpell;
import elucent.eidolon.common.spell.ThrallSpell;
import elucent.eidolon.common.spell.UndeadLureSpell;
import elucent.eidolon.common.spell.VillagerSacrificeSpell;
import elucent.eidolon.common.spell.WaterSpell;
import elucent.eidolon.common.spell.ZombifySpell;
import elucent.eidolon.recipe.ChantRecipe;
import elucent.eidolon.registries.EidolonRecipes;
import elucent.eidolon.registries.Signs;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class Spells {
    static final List<Spell> spells = new CopyOnWriteArrayList<Spell>();
    static final Map<ResourceLocation, Spell> spellMap = new ConcurrentHashMap<ResourceLocation, Spell>();
    public static final Spell DARK_PRAYER = Spells.register(new PrayerSpell(new ResourceLocation("eidolon", "dark_prayer"), Deities.DARK_DEITY, Signs.WICKED_SIGN, Signs.WICKED_SIGN, Signs.WICKED_SIGN));
    public static final Spell DARKLIGHT_CHANT = Spells.register(new LightSpell(new ResourceLocation("eidolon", "darklight_chant"), Deities.DARK_DEITY, Signs.WICKED_SIGN, Signs.FLAME_SIGN, Signs.WICKED_SIGN, Signs.FLAME_SIGN));
    public static final Spell DARK_ANIMAL_SACRIFICE = Spells.register(new AnimalSacrificeSpell(new ResourceLocation("eidolon", "dark_animal_sacrifice"), Deities.DARK_DEITY, Signs.WICKED_SIGN, Signs.BLOOD_SIGN, Signs.WICKED_SIGN));
    public static final Spell DARK_TOUCH = Spells.register(new DarkTouchSpell(new ResourceLocation("eidolon", "dark_touch"), Signs.WICKED_SIGN, Signs.SOUL_SIGN, Signs.WICKED_SIGN, Signs.SOUL_SIGN));
    public static final Spell FROST_CHANT = Spells.register(new FrostSpell(new ResourceLocation("eidolon", "frost_touch"), Signs.WICKED_SIGN, Signs.WINTER_SIGN, Signs.BLOOD_SIGN, Signs.WINTER_SIGN, Signs.WICKED_SIGN));
    public static final Spell DARK_VILLAGER_SACRIFICE = Spells.register(new VillagerSacrificeSpell(new ResourceLocation("eidolon", "dark_villager_sacrifice"), Deities.DARK_DEITY, Signs.BLOOD_SIGN, Signs.WICKED_SIGN, Signs.BLOOD_SIGN, Signs.SOUL_SIGN));
    public static final Spell ZOMBIFY = Spells.register(new ZombifySpell(new ResourceLocation("eidolon", "zombify_villager"), Signs.DEATH_SIGN, Signs.BLOOD_SIGN, Signs.WICKED_SIGN, Signs.DEATH_SIGN, Signs.SOUL_SIGN, Signs.BLOOD_SIGN));
    public static final Spell ENTHRALL_UNDEAD = Spells.register(new ThrallSpell(new ResourceLocation("eidolon", "enthrall_spell"), Signs.WICKED_SIGN, Signs.MIND_SIGN, Signs.MAGIC_SIGN, Signs.MAGIC_SIGN, Signs.MIND_SIGN));
    public static final Spell LIGHT_PRAYER = Spells.register(new PrayerSpell(new ResourceLocation("eidolon", "light_prayer"), Deities.LIGHT_DEITY, Signs.SACRED_SIGN, Signs.SACRED_SIGN, Signs.SACRED_SIGN));
    public static final Spell FIRE_CHANT = Spells.register(new FireTouchSpell(new ResourceLocation("eidolon", "fire_chant"), Signs.FLAME_SIGN, Signs.FLAME_SIGN, Signs.FLAME_SIGN));
    public static final Spell LIGHT_CHANT = Spells.register(new LightSpell(new ResourceLocation("eidolon", "light_chant"), Deities.LIGHT_DEITY, Signs.SACRED_SIGN, Signs.FLAME_SIGN, Signs.SACRED_SIGN, Signs.FLAME_SIGN));
    public static final Spell HOLY_TOUCH = Spells.register(new LightTouchSpell(new ResourceLocation("eidolon", "holy_touch"), Signs.SACRED_SIGN, Signs.SOUL_SIGN, Signs.SACRED_SIGN, Signs.SOUL_SIGN));
    public static final Spell LAY_ON_HANDS = Spells.register(new HealSpell(new ResourceLocation("eidolon", "lay_on_hands"), Signs.FLAME_SIGN, Signs.SOUL_SIGN, Signs.SACRED_SIGN, Signs.SOUL_SIGN, Signs.SACRED_SIGN));
    public static final Spell CURE_ZOMBIE_CHANT = Spells.register(new ConvertZombieSpell(new ResourceLocation("eidolon", "cure_zombie_chant"), Signs.SACRED_SIGN, Signs.SOUL_SIGN, Signs.MIND_SIGN, Signs.HARMONY_SIGN, Signs.FLAME_SIGN, Signs.SOUL_SIGN));
    public static final Spell SMITE_CHANT = Spells.register(new SmiteSpell(new ResourceLocation("eidolon", "smite_chant"), Signs.FLAME_SIGN, Signs.MAGIC_SIGN, Signs.SACRED_SIGN, Signs.DEATH_SIGN, Signs.MAGIC_SIGN, Signs.SACRED_SIGN));
    public static final Spell SUNDER_ARMOR = Spells.register(new SunderArmorSpell(new ResourceLocation("eidolon", "sunder_armor"), Signs.FLAME_SIGN, Signs.MAGIC_SIGN, Signs.WICKED_SIGN, Signs.MAGIC_SIGN, Signs.FLAME_SIGN));
    public static final Spell BLESS_ARMOR = Spells.register(new LightArmorSpell(new ResourceLocation("eidolon", "reinforce_armor"), Signs.SACRED_SIGN, Signs.WARDING_SIGN, Signs.SACRED_SIGN, Signs.WARDING_SIGN, Signs.SACRED_SIGN));
    public static final Spell WATER_CHANT = Spells.register(new WaterSpell(new ResourceLocation("eidolon", "water"), Signs.WINTER_SIGN, Signs.WINTER_SIGN, Signs.FLAME_SIGN, Signs.FLAME_SIGN));
    public static final Spell UNDEAD_LURE = Spells.register(new UndeadLureSpell(new ResourceLocation("eidolon", "undead_lure"), Signs.MIND_SIGN, Signs.MAGIC_SIGN, Signs.WICKED_SIGN));

    public static Spell find(ResourceLocation loc) {
        return spellMap.getOrDefault(loc, null);
    }

    public static Spell find(SignSequence signs, Level world) {
        for (Spell spell : spells) {
            if (!spell.matches(signs)) continue;
            return spell;
        }
        for (ChantRecipe chantRecipe : world.m_7465_().m_44013_((RecipeType)EidolonRecipes.CHANT_TYPE.get())) {
            if (!chantRecipe.matches(signs)) continue;
            Spell spell = chantRecipe.getChant();
            spell.setSigns(signs);
            spells.add(spell);
            return spell;
        }
        return null;
    }

    public static Spell register(Spell spell) {
        spellMap.put(spell.getRegistryName(), spell);
        return spell;
    }

    public static List<Spell> getSpells() {
        return spells;
    }
}

