/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.network;

import elucent.eidolon.Eidolon;
import elucent.eidolon.client.particle.Particles;
import elucent.eidolon.registries.EidolonParticles;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class LifestealEffectPacket {
    final BlockPos src;
    final BlockPos dst;
    final float r;
    final float g;
    final float b;

    public LifestealEffectPacket(BlockPos src, BlockPos dst, float r, float g, float b) {
        this.src = src;
        this.dst = dst;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public static void encode(LifestealEffectPacket object, FriendlyByteBuf buffer) {
        buffer.m_130064_(object.src).m_130064_(object.dst);
        buffer.writeFloat(object.r).writeFloat(object.g).writeFloat(object.b);
    }

    public static LifestealEffectPacket decode(FriendlyByteBuf buffer) {
        return new LifestealEffectPacket(buffer.m_130135_(), buffer.m_130135_(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
    }

    public static void consume(LifestealEffectPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            assert (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT);
            Level world = Eidolon.proxy.getWorld();
            if (world != null) {
                BlockPos src = packet.src;
                BlockPos dst = packet.dst;
                for (int i = 0; i < 10; ++i) {
                    Particles.create(EidolonParticles.LINE_WISP_PARTICLE).setAlpha(0.75f, 0.0f).setScale(0.25f + 0.125f * world.f_46441_.m_188501_(), 0.0f).setLifetime(16 + world.f_46441_.m_188503_(4)).randomOffset(0.375, 0.375).randomVelocity(0.125, 0.125).addVelocity((double)dst.m_123341_() + 0.5, (double)dst.m_123342_() + 0.5, (double)dst.m_123343_() + 0.5).setColor(packet.r, packet.g, packet.b, packet.r, packet.g * 0.5f, packet.b * 1.5f).spawn(world, (double)src.m_123341_() + 0.5, (double)src.m_123342_() + 0.5, (double)src.m_123343_() + 0.5);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

