/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.gui;

import elucent.eidolon.api.research.Research;
import elucent.eidolon.api.research.ResearchTask;
import elucent.eidolon.common.tile.ResearchTableTileEntity;
import elucent.eidolon.mixin.AbstractContainerMenuMixin;
import elucent.eidolon.registries.Registry;
import elucent.eidolon.registries.Researches;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class ResearchTableContainer
extends AbstractContainerMenu
implements ContainerListener {
    private final Container tile;
    private final ContainerData intArray;
    protected final List<ResearchTask> tasks;

    public ResearchTableContainer(int id, Inventory playerInventory) {
        this(id, playerInventory, (Container)new SimpleContainer(2), (ContainerData)new SimpleContainerData(2));
    }

    public ResearchTableContainer(int id, Inventory playerInventory, Container inventory, ContainerData data) {
        super((MenuType)Registry.RESEARCH_TABLE_CONTAINER.get(), id);
        this.tile = inventory;
        this.intArray = data;
        this.m_38897_(new NotesSlot(inventory, 0, 58, 68));
        this.m_38897_(new SealSlot(inventory, 1, 58, 32));
        this.m_38884_(data);
        this.tasks = new ArrayList<ResearchTask>();
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.m_38897_(new Slot((Container)playerInventory, i1 + k * 9 + 9, 16 + i1 * 18, 142 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.m_38897_(new Slot((Container)playerInventory, l, 16 + l * 18, 200));
        }
        if (inventory instanceof ResearchTableTileEntity) {
            ResearchTableTileEntity t = (ResearchTableTileEntity)inventory;
            t.addListener(this);
        }
        if (this.tile instanceof ResearchTableTileEntity) {
            this.updateSlots();
        }
    }

    protected void popSlot() {
        this.f_38839_.remove(this.f_38839_.size() - 1);
        NonNullList<ItemStack> lastSlots = ((AbstractContainerMenuMixin)((Object)this)).getLastSlots();
        NonNullList<ItemStack> remoteSlots = ((AbstractContainerMenuMixin)((Object)this)).getRemoteSlots();
        lastSlots.remove(lastSlots.size() - 1);
        remoteSlots.remove(remoteSlots.size() - 1);
    }

    public void m_150399_(int pSlotId, int pButton, @NotNull ClickType pClickType, @NotNull Player pPlayer) {
        if (pSlotId >= this.f_38839_.size()) {
            return;
        }
        super.m_150399_(pSlotId, pButton, pClickType, pPlayer);
    }

    public void updateSlots() {
        Container container = this.tile;
        if (container instanceof ResearchTableTileEntity) {
            ResearchTableTileEntity t = (ResearchTableTileEntity)container;
            for (int i = 38; i < this.f_38839_.size(); ++i) {
                if (((Slot)this.f_38839_.get(i)).m_7993_().m_41619_()) continue;
                double d0 = (float)t.m_58899_().m_123342_() + 1.3f;
                ItemEntity itementity = new ItemEntity(t.m_58904_(), (double)t.m_58899_().m_123341_() + 0.5, d0, (double)t.m_58899_().m_123343_() + 0.5, ((Slot)this.f_38839_.get(i)).m_7993_());
                itementity.m_32010_(40);
                t.m_58904_().m_7967_((Entity)itementity);
            }
        }
        while (this.f_38839_.size() > 38) {
            this.popSlot();
        }
        this.checkTask();
        if (this.tile instanceof ResearchTableTileEntity) {
            this.m_182423_();
        }
    }

    private void checkTask() {
        if (!((Slot)this.f_38839_.get(0)).m_7993_().m_150930_((Item)Registry.RESEARCH_NOTES.get()) || this.getProgress() > 0) {
            return;
        }
        ItemStack stack = ((Slot)this.f_38839_.get(0)).m_7993_();
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_("research")) {
            return;
        }
        Research r = Researches.find(new ResourceLocation(tag.m_128461_("research")));
        if (r == null || tag.m_128451_("stepsDone") >= r.getStars()) {
            return;
        }
        List<ResearchTask> tasks = r.getTasks(this.getSeed(stack), tag.m_128451_("stepsDone"));
        for (int i = 0; i < tasks.size(); ++i) {
            int x = 189;
            int y = 17 + 36 * i;
            tasks.get(i).modifyContainer(this, x, y);
        }
    }

    public void m_6877_(@NotNull Player player) {
        Container container;
        super.m_6877_(player);
        if (player instanceof ServerPlayer) {
            for (int i = 38; i < this.f_38839_.size(); ++i) {
                if (((Slot)this.f_38839_.get(i)).m_7993_().m_41619_()) continue;
                player.m_36176_(((Slot)this.f_38839_.get(i)).m_7993_(), false);
            }
        }
        if ((container = this.tile) instanceof ResearchTableTileEntity) {
            ResearchTableTileEntity t = (ResearchTableTileEntity)container;
            t.removeListener(this);
        }
    }

    public boolean m_6875_(@NotNull Player playerIn) {
        return this.tile.m_6542_(playerIn);
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < 0 || index > 2 && index < 38) {
                boolean placeInExtraSlots = false;
                for (int extra = 38; extra < this.f_38839_.size(); ++extra) {
                    placeInExtraSlots = placeInExtraSlots || ((Slot)this.f_38839_.get(extra)).m_5857_(itemstack1);
                }
                if (placeInExtraSlots ? !this.m_38903_(itemstack1, 38, this.f_38839_.size(), false) : (((Slot)this.f_38839_.get(0)).m_5857_(itemstack1) ? !this.m_38903_(itemstack1, 0, 1, false) : (((Slot)this.f_38839_.get(1)).m_5857_(itemstack1) ? !this.m_38903_(itemstack1, 1, 2, false) : (index >= 2 && index < 29 ? !this.m_38903_(itemstack1, 29, 38, false) : (index >= 29 ? !this.m_38903_(itemstack1, 2, 29, false) : !this.m_38903_(itemstack1, 2, 38, false)))))) {
                    return ItemStack.f_41583_;
                }
            } else {
                if (!this.m_38903_(itemstack1, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, itemstack1);
        }
        return itemstack;
    }

    public int getProgress() {
        return this.intArray.m_6413_(0);
    }

    public int getSeed(ItemStack stack) {
        if (!stack.m_41782_() || !stack.m_41783_().m_128441_("seed")) {
            return 0;
        }
        return stack.m_41783_().m_128451_("seed");
    }

    public void m_182410_(int id, List<ItemStack> items, @NotNull ItemStack carried) {
        ((Slot)this.f_38839_.get(0)).m_5852_(items.get(0).m_41777_());
        this.updateSlots();
        try {
            super.m_182410_(id, items, carried);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }

    public void trySubmitGoal(Player player, int index) {
        if (((Slot)this.f_38839_.get(0)).m_7993_().m_150930_((Item)Registry.RESEARCH_NOTES.get())) {
            ItemStack stack = ((Slot)this.f_38839_.get(0)).m_7993_();
            if (!stack.m_41782_() || !stack.m_41783_().m_128441_("research")) {
                return;
            }
            Research r = Researches.find(new ResourceLocation(stack.m_41783_().m_128461_("research")));
            if (r == null) {
                return;
            }
            List<ResearchTask> tasks = r.getTasks(this.getSeed(stack), stack.m_41783_().m_128451_("stepsDone"));
            if (tasks.size() < index) {
                return;
            }
            ResearchTask toComplete = tasks.get(index);
            int startingSlot = 38;
            for (int i = 0; i < index; ++i) {
                startingSlot += tasks.get(i).getSlotCount();
            }
            if (!toComplete.isComplete(this, player, startingSlot).complete()) {
                return;
            }
            toComplete.onComplete(this, player, startingSlot);
            this.m_7511_(0, 200);
            this.m_38946_();
            this.updateSlots();
        }
    }

    public void tryStamp(Player player) {
        if (((Slot)this.f_38839_.get(0)).m_7993_().m_150930_((Item)Registry.RESEARCH_NOTES.get()) && ((Slot)this.f_38839_.get(1)).m_7993_().m_150930_((Item)Registry.ARCANE_SEAL.get())) {
            ItemStack notes = ((Slot)this.f_38839_.get(0)).m_7993_();
            if (!notes.m_41782_() || !notes.m_41783_().m_128441_("research")) {
                return;
            }
            Research r = Researches.find(new ResourceLocation(notes.m_41783_().m_128461_("research")));
            if (r == null) {
                return;
            }
            if (notes.m_41783_().m_128451_("stepsDone") < r.getStars()) {
                return;
            }
            ((Slot)this.f_38839_.get(1)).m_6201_(1);
            ItemStack completed = new ItemStack((ItemLike)Registry.COMPLETED_RESEARCH.get());
            completed.m_41784_().m_128359_("research", r.getRegistryName().toString());
            ((Slot)this.f_38839_.get(0)).m_5852_(completed);
            this.updateSlots();
        }
    }

    public void m_7934_(@NotNull AbstractContainerMenu menu, int slot, @NotNull ItemStack stack) {
        if (slot == 0) {
            this.updateSlots();
        }
    }

    public void m_142153_(@NotNull AbstractContainerMenu menu, int slot, int value) {
        if (slot == 0 && (value == 0 || value == 200)) {
            this.updateSlots();
        }
    }

    class NotesSlot
    extends Slot {
        public NotesSlot(Container iInventoryIn, int index, int xPosition, int yPosition) {
            super(iInventoryIn, index, xPosition, yPosition);
        }

        public boolean m_5857_(ItemStack stack) {
            return stack.m_150930_((Item)Registry.RESEARCH_NOTES.get());
        }

        public boolean m_8010_(@NotNull Player pPlayer) {
            if (ResearchTableContainer.this.getProgress() > 0) {
                return false;
            }
            return super.m_8010_(pPlayer);
        }

        public void m_6654_() {
            super.m_6654_();
            if (ResearchTableContainer.this.tile instanceof ResearchTableTileEntity) {
                ResearchTableContainer.this.updateSlots();
            }
        }

        public int m_6641_() {
            return 1;
        }
    }

    static class SealSlot
    extends Slot {
        public SealSlot(Container iInventoryIn, int index, int xPosition, int yPosition) {
            super(iInventoryIn, index, xPosition, yPosition);
        }

        public boolean m_5857_(ItemStack stack) {
            return stack.m_150930_((Item)Registry.ARCANE_SEAL.get());
        }

        public int m_6641_() {
            return 64;
        }
    }
}

