/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.datagen;

import com.google.common.collect.Maps;
import elucent.eidolon.registries.AdvancementTriggers;
import elucent.eidolon.registries.Registry;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import net.minecraftforge.common.extensions.IForgeAdvancementBuilder;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EidAdvancementProvider
extends ForgeAdvancementProvider {
    public EidAdvancementProvider(DataGenerator generatorIn, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper fileHelperIn) {
        super(generatorIn.getPackOutput(), registries, fileHelperIn, List.of(new EidolonAdvancements()));
    }

    static class EidolonAdvancements
    implements ForgeAdvancementProvider.AdvancementGenerator {
        Consumer<Advancement> advCon;

        EidolonAdvancements() {
        }

        public void generate(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider registries, @NotNull Consumer<Advancement> con, @NotNull ExistingFileHelper existingFileHelper) {
            this.advCon = con;
            Advancement root = this.builder("eidolon").display((ItemLike)Registry.CODEX.get(), (Component)Component.m_237115_((String)"eidolon.advancement.title.root"), (Component)Component.m_237115_((String)"eidolon.advancement.desc.root"), new ResourceLocation("eidolon:textures/block/bone_pile.png"), FrameType.TASK, false, false, false).addCriterion("eidolon:ars_ecclesia", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)Registry.CODEX.get()})).save(con, "eidolon:root");
            Advancement theurgy = this.saveBasicItem((ItemLike)Registry.STRAW_EFFIGY.get(), root);
            Advancement altar = this.saveBasicItem((ItemLike)Registry.WOODEN_ALTAR.get(), theurgy);
            this.saveBasicItem((ItemLike)Registry.STONE_ALTAR.get(), altar);
            Advancement sacredRoot = this.saveWithTrigger(theurgy, (ItemLike)Registry.HOLY_SYMBOL.get(), AdvancementTriggers.SACRED);
            Advancement incense = this.saveWithTrigger(sacredRoot, (ItemLike)Registry.CENSER.get(), AdvancementTriggers.INCENSE);
            Advancement darkRoot = this.saveWithTrigger(theurgy, (ItemLike)Registry.UNHOLY_SYMBOL.get(), AdvancementTriggers.WICKED);
            Advancement goblet = this.saveWithTrigger(darkRoot, (ItemLike)Registry.GOBLET.get(), AdvancementTriggers.SACRIFICE);
            Advancement symbol = this.saveBasicItem((ItemLike)Registry.HOLY_SYMBOL.get(), incense);
            Advancement layHands = this.saveWithTrigger(symbol, (ItemLike)Items.f_42546_, AdvancementTriggers.LAY_ON_HANDS);
            Advancement cureZombie = this.saveWithTrigger(layHands, (ItemLike)Items.f_42436_, AdvancementTriggers.CURE_ZOMBIE);
            symbol = this.saveBasicItem((ItemLike)Registry.UNHOLY_SYMBOL.get(), goblet);
            Advancement v_sacrifice = this.saveWithTrigger(symbol, (ItemLike)Items.f_42383_, AdvancementTriggers.VSACRIFICE);
            Advancement zombify = this.saveWithTrigger(v_sacrifice, (ItemLike)Registry.ZOMBIE_HEART.get(), AdvancementTriggers.ZOMBIFY);
            Advancement artificeRoot = this.saveBasicItem((ItemLike)Registry.PEWTER_INGOT.get(), root);
            Advancement alchemy = this.saveBasicItem((ItemLike)Registry.CRUCIBLE.get(), artificeRoot);
            Advancement researchs = this.saveBasicItem((ItemLike)Registry.RESEARCH_NOTES.get(), alchemy);
            this.saveWithTrigger(researchs, (ItemLike)Blocks.f_50683_, AdvancementTriggers.FLAME);
            this.saveWithTrigger(researchs, (ItemLike)Blocks.f_50568_, AdvancementTriggers.FROST);
            Advancement apothecary = this.saveBasicItem((ItemLike)Registry.WOODEN_STAND.get(), alchemy);
            Advancement worktable = this.saveBasicItem((ItemLike)Registry.WORKTABLE.get(), artificeRoot);
            Advancement athame = this.saveBasicItem((ItemLike)Registry.ATHAME.get(), worktable);
            Advancement scythe = this.saveBasicItem((ItemLike)Registry.REAPER_SCYTHE.get(), worktable);
            Advancement braziers = this.saveBasicItem((ItemLike)Registry.BRAZIER.get(), artificeRoot);
            Advancement soulShard = this.saveBasicItem((ItemLike)Registry.SOUL_SHARD.get(), braziers);
        }

        private Advancement saveWithTrigger(Advancement parent, @NotNull ItemLike display, PlayerTrigger playerTrigger) {
            return this.builder(playerTrigger.m_7295_().m_135815_()).display(display, FrameType.TASK).addCriterion((CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(playerTrigger.m_7295_(), ContextAwarePredicate.f_285567_)).parent(parent).save(this.advCon);
        }

        public AdvancementBuilder buildBasicItem(ItemLike item, Advancement parent) {
            return this.builder(ForgeRegistries.ITEMS.getKey((Object)item.m_5456_()).m_135815_()).normalItemRequirement(item).parent(parent);
        }

        public Advancement saveBasicItem(ItemLike item, Advancement parent) {
            return this.buildBasicItem(item, parent).save(this.advCon);
        }

        public AdvancementBuilder builder(String key) {
            return AdvancementBuilder.builder("eidolon", key);
        }
    }

    static class AdvancementBuilder
    implements IForgeAdvancementBuilder {
        @javax.annotation.Nullable
        private ResourceLocation parentId;
        @javax.annotation.Nullable
        private Advancement parent;
        @javax.annotation.Nullable
        private DisplayInfo display;
        private AdvancementRewards rewards = AdvancementRewards.f_9978_;
        private Map<String, Criterion> criteria = Maps.newLinkedHashMap();
        @javax.annotation.Nullable
        private String[][] requirements;
        private RequirementsStrategy requirementsStrategy = RequirementsStrategy.f_15978_;
        private String modid;
        private String fileKey;

        private AdvancementBuilder(@javax.annotation.Nullable ResourceLocation pParentId, @javax.annotation.Nullable DisplayInfo pDisplay, AdvancementRewards pRewards, Map<String, Criterion> pCriteria, String[] @Nullable [] pRequirements) {
            this.parentId = pParentId;
            this.display = pDisplay;
            this.rewards = pRewards;
            this.criteria = pCriteria;
            this.requirements = pRequirements;
        }

        private AdvancementBuilder(String modid, String fileKey) {
            this.modid = modid;
            this.fileKey = fileKey;
        }

        public static AdvancementBuilder builder(String modid, String fileKey) {
            return new AdvancementBuilder(modid, fileKey);
        }

        public AdvancementBuilder parent(Advancement pParent) {
            this.parent = pParent;
            return this;
        }

        public AdvancementBuilder parent(ResourceLocation pParentId) {
            this.parentId = pParentId;
            return this;
        }

        public AdvancementBuilder display(ItemStack pStack, Component pTitle, Component pDescription, @javax.annotation.Nullable ResourceLocation pBackground, FrameType pFrame, boolean pShowToast, boolean pAnnounceToChat, boolean pHidden) {
            return this.display(new DisplayInfo(pStack, pTitle, pDescription, pBackground, pFrame, pShowToast, pAnnounceToChat, pHidden));
        }

        public AdvancementBuilder display(ItemLike pItem, Component pTitle, Component pDescription, @javax.annotation.Nullable ResourceLocation pBackground, FrameType pFrame, boolean pShowToast, boolean pAnnounceToChat, boolean pHidden) {
            return this.display(new DisplayInfo(new ItemStack((ItemLike)pItem.m_5456_()), pTitle, pDescription, pBackground, pFrame, pShowToast, pAnnounceToChat, pHidden));
        }

        public AdvancementBuilder display(DisplayInfo pDisplay) {
            this.display = pDisplay;
            return this;
        }

        public AdvancementBuilder display(ItemStack pItem, FrameType pFrame) {
            return this.display(new DisplayInfo(pItem, (Component)this.getComponent("title"), (Component)this.getComponent("desc"), null, pFrame, true, true, false));
        }

        public AdvancementBuilder display(ItemLike pItem, FrameType pFrame) {
            return this.display(new ItemStack(pItem), pFrame);
        }

        public AdvancementBuilder display(ItemStack pItem, FrameType pFrame, boolean hidden) {
            return this.display(new DisplayInfo(pItem, (Component)this.getComponent("title"), (Component)this.getComponent("desc"), null, pFrame, true, true, hidden));
        }

        public AdvancementBuilder display(ItemLike pItem, FrameType pFrame, boolean hidden) {
            return this.display(new ItemStack(pItem), pFrame, hidden);
        }

        public AdvancementBuilder rewards(AdvancementRewards.Builder pRewardsBuilder) {
            return this.rewards(pRewardsBuilder.m_10004_());
        }

        public AdvancementBuilder rewards(AdvancementRewards pRewards) {
            this.rewards = pRewards;
            return this;
        }

        public AdvancementBuilder addCriterion(String pKey, CriterionTriggerInstance pCriterion) {
            return this.addCriterion(pKey, new Criterion(pCriterion));
        }

        public AdvancementBuilder addCriterion(CriterionTriggerInstance pCriterion) {
            return this.addCriterion(this.fileKey, new Criterion(pCriterion));
        }

        public AdvancementBuilder addCriterion(String pKey, Criterion pCriterion) {
            if (this.criteria.containsKey(pKey)) {
                throw new IllegalArgumentException("Duplicate criterion " + pKey);
            }
            this.criteria.put(pKey, pCriterion);
            return this;
        }

        public AdvancementBuilder requirements(RequirementsStrategy pStrategy) {
            this.requirementsStrategy = pStrategy;
            return this;
        }

        public AdvancementBuilder requirements(String[][] pRequirements) {
            this.requirements = pRequirements;
            return this;
        }

        public AdvancementBuilder normalItemRequirement(ItemLike item) {
            return this.display(item, FrameType.TASK).requireItem(item);
        }

        public AdvancementBuilder requireItem(ItemLike item) {
            return this.addCriterion("has_" + ForgeRegistries.ITEMS.getKey((Object)item.m_5456_()).m_135815_(), (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{item}));
        }

        public MutableComponent getComponent(String type) {
            return Component.m_237115_((String)(this.modid + ".advancement." + type + "." + this.fileKey));
        }

        public boolean canBuild(Function<ResourceLocation, Advancement> pParentLookup) {
            if (this.parentId == null) {
                return true;
            }
            if (this.parent == null) {
                this.parent = pParentLookup.apply(this.parentId);
            }
            return this.parent != null;
        }

        public Advancement build(ResourceLocation pId) {
            if (!this.canBuild(p_138407_ -> null)) {
                throw new IllegalStateException("Tried to build incomplete advancement!");
            }
            if (this.requirements == null) {
                this.requirements = this.requirementsStrategy.m_15985_(this.criteria.keySet());
            }
            return new Advancement(pId, this.parent, this.display, this.rewards, this.criteria, this.requirements, false);
        }

        public Advancement save(Consumer<Advancement> pConsumer, String pId) {
            Advancement advancement = this.build(new ResourceLocation(pId));
            pConsumer.accept(advancement);
            return advancement;
        }

        public Advancement save(Consumer<Advancement> pConsumer) {
            return this.save(pConsumer, new ResourceLocation(this.modid, this.fileKey).toString());
        }

        public String toString() {
            return "Task Advancement{parentId=" + this.parentId + ", display=" + this.display + ", rewards=" + this.rewards + ", criteria=" + this.criteria + ", requirements=" + Arrays.deepToString((Object[])this.requirements) + "}";
        }

        public Map<String, Criterion> getCriteria() {
            return this.criteria;
        }
    }
}

