/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.item.curio;

import elucent.eidolon.capability.IPlayerData;
import elucent.eidolon.common.item.IWingsItem;
import elucent.eidolon.common.item.curio.EidolonCurio;
import elucent.eidolon.registries.Registry;
import java.util.UUID;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class RavenCloakItem
extends EidolonCurio
implements IWingsItem {
    UUID ATTR_ID = new UUID(261693807752044433L, 1154961640602571210L);
    public static final int MAX_CHARGES = 10;

    public RavenCloakItem(Item.Properties properties) {
        super(properties);
        MinecraftForge.EVENT_BUS.addListener(RavenCloakItem::onFall);
    }

    @SubscribeEvent
    public static void onFall(LivingFallEvent event) {
        if (CuriosApi.getCuriosHelper().findFirstCurio(event.getEntity(), (Item)Registry.GRAVITY_BELT.get()).isPresent()) {
            event.setDistance(event.getDistance() / 4.0f);
        }
    }

    @Override
    public int getMaxCharges(ItemStack stack) {
        return 10;
    }

    @Override
    public void onFlap(Player player, Level level, ItemStack stack, int nCharges) {
        player.m_20256_(player.m_20184_().m_82549_(player.m_20154_().m_82490_(0.25)).m_82542_(1.0, 0.0, 1.0).m_82520_(0.0, 0.5, 0.0));
    }

    @Override
    public int getDashTicks(ItemStack stack) {
        return 100;
    }

    @Override
    public void onDashStart(Player player, Level level, ItemStack stack) {
    }

    @Override
    public void onDashTick(Player player, Level level, ItemStack stack, int remainingTicks) {
        float coeff = (float)remainingTicks / (float)this.getDashTicks(stack);
        coeff = 1.0f - (1.0f - coeff) * (1.0f - coeff) + 0.25f;
        player.m_20256_(player.m_20184_().m_82490_(0.8).m_82549_(player.m_20154_().m_82490_((double)coeff * 0.2)));
    }

    @Override
    public void onDashEnd(Player player, Level level, ItemStack stack) {
    }

    @Override
    public void onDashFlap(Player player, Level level, ItemStack stack, int dashTicks) {
        player.getCapability(IPlayerData.INSTANCE).ifPresent(d -> d.setDashTicks(this.getDashTicks(stack)));
    }
}

