/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.item;

import elucent.eidolon.client.particle.Particles;
import elucent.eidolon.common.item.ItemBase;
import elucent.eidolon.network.MagicBurstEffectPacket;
import elucent.eidolon.network.Networking;
import elucent.eidolon.registries.EidolonParticles;
import elucent.eidolon.util.ColorUtil;
import elucent.eidolon.util.EntityUtil;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class SummoningStaffItem
extends ItemBase {
    public SummoningStaffItem(Item.Properties builderIn) {
        super(builderIn);
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 72000;
    }

    public void m_5929_(@NotNull Level pLevel, LivingEntity entity, @NotNull ItemStack stack, int time) {
        HitResult hit;
        if (entity.f_19853_.f_46443_ && (hit = entity.m_19907_(16.0, 0.0f, false)).m_6662_() != HitResult.Type.MISS) {
            Vec3 pos = hit.m_82450_();
            time = 72000 - time;
            float alpha = Mth.m_14036_((float)((float)time / 40.0f), (float)0.0f, (float)1.0f);
            float a = (float)Math.PI / 180 * (float)(entity.f_19853_.m_46467_() % 360L + (long)(12 * time));
            float r = 0.3f + 0.3f * alpha;
            float sa = r * Mth.m_14031_((float)a);
            float ca = r * Mth.m_14089_((float)a);
            if (time == 40) {
                entity.m_5496_(SoundEvents.f_11846_, 1.0f, 1.0f);
            }
            Particles.create(EidolonParticles.SMOKE_PARTICLE).randomVelocity(0.025f * alpha, 0.0125f * alpha).setColor(0.12941177f, 0.101960786f, 0.09019608f, 0.125f, 0.039215688f, 0.039215688f, 0.047058824f, 0.0f).setAlpha(0.25f * alpha, 0.0f).randomOffset(0.05f + 0.05f * alpha).setScale(0.25f + 0.25f * alpha, alpha * 0.125f).repeat(entity.f_19853_, pos.f_82479_ + (double)sa, pos.f_82480_, pos.f_82481_ + (double)ca, 2).repeat(entity.f_19853_, pos.f_82479_ - (double)sa, pos.f_82480_, pos.f_82481_ - (double)ca, 2);
        }
    }

    public void m_5551_(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity, int time) {
        if (72000 - time >= 20 && this.hasCharges(stack)) {
            ListTag charges = this.getCharges(stack);
            int selected = this.getSelected(stack);
            CompoundTag tag = charges.m_128728_(selected);
            HitResult hit = entity.m_19907_(16.0, 0.0f, false);
            if (hit.m_6662_() != HitResult.Type.MISS) {
                Vec3 pos = hit.m_82450_();
                Optional etype = EntityType.m_20637_((CompoundTag)tag);
                if (etype.isPresent() && !level.f_46443_) {
                    tag.m_128473_("UUID");
                    EntityType cfr_ignored_0 = (EntityType)etype.get();
                    Optional e = EntityType.m_20642_((CompoundTag)tag, (Level)level);
                    if (e.isPresent()) {
                        ((Entity)e.get()).m_146884_(pos);
                        EntityUtil.enthrall(entity, (LivingEntity)e.get());
                        level.m_7967_((Entity)e.get());
                        Networking.sendToTracking(entity.f_19853_, ((Entity)e.get()).m_20183_(), new MagicBurstEffectPacket(((Entity)e.get()).m_20185_(), ((Entity)e.get()).m_20186_() + (double)(((Entity)e.get()).m_20206_() / 2.0f), ((Entity)e.get()).m_20189_(), ColorUtil.packColor(255, 61, 70, 35), ColorUtil.packColor(255, 36, 24, 41)));
                        level.m_5594_(null, ((Entity)e.get()).m_20183_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 0.75f, 0.1f);
                    }
                }
                entity.m_21008_(entity.m_7655_(), entity instanceof Player && ((Player)entity).m_150110_().f_35937_ ? stack : this.consumeCharge(stack, selected));
                entity.m_6674_(entity.m_7655_());
                entity.m_5810_();
            }
        }
    }

    public int getSelected(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("selected")) {
            tag.m_128405_("selected", 0);
        } else if (tag.m_128451_("selected") >= this.getCharges(stack).size()) {
            tag.m_128405_("selected", 0);
        }
        return tag.m_128451_("selected");
    }

    public int changeSelection(ItemStack stack, int diff) {
        if (!this.hasCharges(stack)) {
            return 0;
        }
        CompoundTag tag = stack.m_41784_();
        int selected = this.getSelected(stack) + diff % this.getCharges(stack).size();
        tag.m_128405_("selected", selected);
        return selected;
    }

    public ItemStack addCharges(ItemStack stack, ListTag charges) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("charges")) {
            while (charges.size() > 100) {
                charges.remove(charges.size() - 1);
            }
            tag.m_128365_("charges", (Tag)charges);
        } else {
            ListTag existing = tag.m_128437_("charges", 10);
            while (existing.size() + charges.size() > 100) {
                charges.remove(charges.size() - 1);
            }
            if (charges.size() > 0) {
                existing.addAll((Collection)charges);
            }
            tag.m_128365_("charges", (Tag)existing);
        }
        return stack;
    }

    public boolean hasCharges(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        ListTag list = tag.m_128437_("charges", 10);
        return tag.m_128441_("charges") && list.size() > 0;
    }

    public ListTag getCharges(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128441_("charges") ? tag.m_128437_("charges", 10) : new ListTag();
    }

    public ItemStack consumeCharge(ItemStack stack, int index) {
        ListTag list = this.getCharges(stack);
        if (list.size() > index) {
            list.remove(index);
        }
        stack.m_41784_().m_128365_("charges", (Tag)list);
        return stack;
    }

    public ItemStack addCharge(ItemStack stack, CompoundTag tag) {
        ListTag list = this.getCharges(stack);
        if (list.size() < 100) {
            list.add((Object)tag);
        }
        stack.m_41784_().m_128365_("charges", (Tag)list);
        return stack;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.hasCharges(stack)) {
            if (player.m_6047_()) {
                this.changeSelection(stack, 1);
                CompoundTag tag = this.getCharges(stack).m_128728_(this.getSelected(stack));
                ResourceLocation id = new ResourceLocation(tag.m_128461_("id"));
                String summonKey = "entity." + id.m_135827_() + "." + id.m_135815_();
                player.m_21008_(hand, stack);
                if (!world.f_46443_) {
                    ((ServerPlayer)player).f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"eidolon.tooltip.active_summon").m_7220_((Component)Component.m_237115_((String)summonKey).m_130940_(ChatFormatting.LIGHT_PURPLE))));
                    player.m_6330_((SoundEvent)SoundEvents.f_12490_.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
                }
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        boolean charge = this.hasCharges(stack);
        int selected = this.getSelected(stack);
        Object summonKey = "eidolon.tooltip.no_selected_summon";
        if (charge) {
            CompoundTag tag = this.getCharges(stack).m_128728_(selected);
            String ids = tag.m_128461_("id");
            ResourceLocation id = new ResourceLocation(tag.m_128461_("id"));
            summonKey = "entity." + id.m_135827_() + "." + id.m_135815_();
        }
        tooltip.add((Component)Component.m_237115_((String)"eidolon.tooltip.active_summon").m_7220_((Component)Component.m_237115_((String)summonKey).m_130940_(charge ? ChatFormatting.LIGHT_PURPLE : ChatFormatting.DARK_PURPLE)));
    }
}

