/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import elucent.eidolon.client.ClientConfig;
import elucent.eidolon.client.particle.SlashParticleData;
import elucent.eidolon.client.particle.SpriteParticleRenderType;
import elucent.eidolon.event.ClientEvents;
import elucent.eidolon.util.RenderUtil;
import java.awt.Color;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class SlashParticle
extends TextureSheetParticle {
    final SlashParticleData data;
    final float[] hsv1 = new float[3];
    final float[] hsv2 = new float[3];

    public SlashParticle(ClientLevel world, SlashParticleData data, double x, double y, double z, double vx, double vy, double vz) {
        super(world, x, y, z, vx, vy, vz);
        this.m_107264_(x, y, z);
        this.data = data;
        float sy = Mth.m_14031_((float)data.yaw);
        float cy = Mth.m_14089_((float)data.yaw);
        float sp = Mth.m_14031_((float)data.pitch);
        float cp = Mth.m_14089_((float)data.pitch);
        this.m_107264_(x -= (double)(sy * cp * data.width * 0.25f), y -= (double)(sp * data.width * 0.25f), z -= (double)(cy * cp * data.width * 0.25f));
        this.f_107215_ = vx;
        this.f_107216_ = vy;
        this.f_107217_ = vz;
        Vec3 dir = Vec3.m_82498_((float)(57.295776f * data.pitch), (float)(57.295776f * data.yaw));
        this.f_107215_ += dir.f_82479_ * (double)(0.025f + world.f_46441_.m_188501_() * 0.025f);
        this.f_107216_ += dir.f_82480_ * (double)(0.025f + world.f_46441_.m_188501_() * 0.025f);
        this.f_107217_ += dir.f_82481_ * (double)(0.025f + world.f_46441_.m_188501_() * 0.025f);
        this.m_107257_(data.lifetime);
        Color.RGBtoHSB((int)(255.0f * Math.min(1.0f, data.r1)), (int)(255.0f * Math.min(1.0f, data.g1)), (int)(255.0f * Math.min(1.0f, data.b1)), this.hsv1);
        Color.RGBtoHSB((int)(255.0f * Math.min(1.0f, data.r2)), (int)(255.0f * Math.min(1.0f, data.g2)), (int)(255.0f * Math.min(1.0f, data.b2)), this.hsv2);
        this.m_107250_(data.rad, data.rad);
        this.updateTraits();
    }

    protected float getCoeff() {
        return (float)this.f_107224_ / (float)this.f_107225_;
    }

    protected float getCoeff(float pticks) {
        return ((float)this.f_107224_ + pticks) / (float)this.f_107225_;
    }

    protected float getSqInvCoeff(float pticks) {
        float inv = ((float)this.f_107225_ - (float)this.f_107224_ + pticks) / (float)this.f_107225_;
        return 1.0f - inv * inv * inv * inv;
    }

    protected void updateTraits() {
        float coeff = this.getCoeff();
        float h = Mth.m_14189_((float)coeff, (float)(360.0f * this.hsv1[0]), (float)(360.0f * this.hsv2[0])) / 360.0f;
        float s = Mth.m_14179_((float)coeff, (float)this.hsv1[1], (float)this.hsv2[1]);
        float v = Mth.m_14179_((float)coeff, (float)this.hsv1[2], (float)this.hsv2[2]);
        int packed = Color.HSBtoRGB(h, s, v);
        float r = (float)FastColor.ARGB32.m_13665_((int)packed) / 255.0f;
        float g = (float)FastColor.ARGB32.m_13667_((int)packed) / 255.0f;
        float b = (float)FastColor.ARGB32.m_13669_((int)packed) / 255.0f;
        this.m_107253_(r, g, b);
        this.m_107271_(Mth.m_14179_((float)coeff, (float)this.data.a1, (float)this.data.a2));
    }

    public void m_5989_() {
        this.updateTraits();
        super.m_5989_();
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return SpriteParticleRenderType.INSTANCE;
    }

    private void decoVert(VertexConsumer vc, float u, float v, float alpha, int lmap) {
        vc.m_7421_(u, v).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, alpha).m_85969_(lmap).m_5752_();
    }

    public void m_5744_(@NotNull VertexConsumer vc, Camera info, float pticks) {
        VertexConsumer b = (Boolean)ClientConfig.BETTER_LAYERING.get() != false ? ClientEvents.getDelayedRender().m_6299_(RenderUtil.DELAYED_PARTICLE) : vc;
        float x = (float)(Mth.m_14139_((double)pticks, (double)this.f_107209_, (double)this.f_107212_) - info.m_90583_().m_7096_());
        float y = (float)(Mth.m_14139_((double)pticks, (double)this.f_107210_, (double)this.f_107213_) - info.m_90583_().m_7098_());
        float z = (float)(Mth.m_14139_((double)pticks, (double)this.f_107211_, (double)this.f_107214_) - info.m_90583_().m_7094_());
        float sy = Mth.m_14031_((float)this.data.yaw);
        float cy = Mth.m_14089_((float)this.data.yaw);
        float sp = Mth.m_14031_((float)this.data.pitch);
        float cp = Mth.m_14089_((float)this.data.pitch);
        float ox = x - sy * cp * this.data.rad;
        float oy = y - sp * this.data.rad;
        float oz = z - cy * cp * this.data.rad;
        float right = this.data.yaw + 1.5707964f;
        float up = this.data.pitch + 1.5707964f;
        float sr = Mth.m_14031_((float)right);
        float cr = Mth.m_14089_((float)right);
        float su = Mth.m_14031_((float)up);
        float cu = Mth.m_14089_((float)up);
        float r = this.data.rad;
        float xax = r * sr * cp;
        float xay = 0.0f;
        float xaz = r * cr * cp;
        float yax = r * sy * cu;
        float yay = r * su;
        float yaz = r * cy * cu;
        float zax = r * sy * cp;
        float zay = r * sp;
        float zaz = r * cy * cp;
        float cro = Mth.m_14089_((float)this.data.roll);
        float sro = Mth.m_14031_((float)this.data.roll);
        float nxax = xax * cro - yax * sro;
        float nxay = xay * cro - yay * sro;
        float nxaz = xaz * cro - yaz * sro;
        yax = xax * sro + yax * cro;
        yay = xay * sro + yay * cro;
        yaz = xaz * sro + yaz * cro;
        xax = nxax;
        xay = nxay;
        xaz = nxaz;
        float u0 = this.m_5970_();
        float u1 = this.m_5952_();
        float v0 = this.m_5951_();
        float v1 = this.m_5950_();
        int lmap = this.m_6355_(pticks);
        float w = this.data.width / 2.0f;
        float hlangle = -this.data.angle / 2.0f + this.getSqInvCoeff(pticks) * this.data.angle;
        float hlwidth = 4.0f + 4.0f * this.getSqInvCoeff(pticks);
        for (float i = 0.0f; i < 18.0f; i += 1.0f) {
            float c1 = i / 18.0f;
            float c2 = (i + 1.0f) / 18.0f;
            float basea = this.f_107230_ - this.data.highlight;
            float angle1 = -this.data.angle / 2.0f + c1 * this.data.angle;
            float angle2 = -this.data.angle / 2.0f + c2 * this.data.angle;
            float al1 = Mth.m_14031_((float)(c1 * (float)Math.PI));
            float al2 = Mth.m_14031_((float)(c2 * (float)Math.PI));
            float dangle1 = Mth.m_14036_((float)((angle1 - hlangle) / this.data.angle), (float)(-1.0f / hlwidth), (float)(1.0f / hlwidth));
            float dangle2 = Mth.m_14036_((float)((angle2 - hlangle) / this.data.angle), (float)(-1.0f / hlwidth), (float)(1.0f / hlwidth));
            float hl1 = (Mth.m_14089_((float)(hlwidth * (float)Math.PI * dangle1)) + 1.0f) / 2.0f;
            float hl2 = (Mth.m_14089_((float)(hlwidth * (float)Math.PI * dangle2)) + 1.0f) / 2.0f;
            al1 = (1.0f - this.data.highlight) * al1 + this.data.highlight * hl1;
            al2 = (1.0f - this.data.highlight) * al2 + this.data.highlight * hl2;
            al1 *= this.f_107230_;
            al2 *= this.f_107230_;
            float w1 = w * (0.25f + 0.75f * Mth.m_14031_((float)(c1 * (float)Math.PI)));
            float w2 = w * (0.25f + 0.75f * Mth.m_14031_((float)(c2 * (float)Math.PI)));
            w1 += this.data.highlight * 0.25f * w * hl1;
            w2 += this.data.highlight * 0.25f * w * hl2;
            float sa1 = Mth.m_14031_((float)angle1);
            float ca1 = Mth.m_14089_((float)angle1);
            float sa2 = Mth.m_14031_((float)angle2);
            float ca2 = Mth.m_14089_((float)angle2);
            float dx1 = sa1 * xax + ca1 * zax;
            float dy1 = sa1 * xay + ca1 * zay;
            float dz1 = sa1 * xaz + ca1 * zaz;
            float dx2 = sa2 * xax + ca2 * zax;
            float dy2 = sa2 * xay + ca2 * zay;
            float dz2 = sa2 * xaz + ca2 * zaz;
            this.decoVert(b.m_5483_((double)(ox + dx2 * r + dx2 * w2), (double)(oy + dy2 * r + dy2 * w2), (double)(oz + dz2 * r + dz2 * w2)), u1, v1, al2, lmap);
            this.decoVert(b.m_5483_((double)(ox + dx2 * r + dx2 * -w2), (double)(oy + dy2 * r + dy2 * -w2), (double)(oz + dz2 * r + dz2 * -w2)), u1, v0, al2, lmap);
            this.decoVert(b.m_5483_((double)(ox + dx1 * r + dx1 * -w1), (double)(oy + dy1 * r + dy1 * -w1), (double)(oz + dz1 * r + dz1 * -w1)), u0, v0, al1, lmap);
            this.decoVert(b.m_5483_((double)(ox + dx1 * r + dx1 * w1), (double)(oy + dy1 * r + dy1 * w1), (double)(oz + dz1 * r + dz1 * w1)), u0, v1, al1, lmap);
            this.decoVert(b.m_5483_((double)(ox + dx2 * r + dx2 * -w2), (double)(oy + dy2 * r + dy2 * -w2), (double)(oz + dz2 * r + dz2 * -w2)), u1, v1, al2, lmap);
            this.decoVert(b.m_5483_((double)(ox + dx2 * r + dx2 * w2), (double)(oy + dy2 * r + dy2 * w2), (double)(oz + dz2 * r + dz2 * w2)), u1, v0, al2, lmap);
            this.decoVert(b.m_5483_((double)(ox + dx1 * r + dx1 * w1), (double)(oy + dy1 * r + dy1 * w1), (double)(oz + dz1 * r + dz1 * w1)), u0, v0, al1, lmap);
            this.decoVert(b.m_5483_((double)(ox + dx1 * r + dx1 * -w1), (double)(oy + dy1 * r + dy1 * -w1), (double)(oz + dz1 * r + dz1 * -w1)), u0, v1, al1, lmap);
            this.decoVert(b.m_5483_((double)(ox + dx2 * r + yax * w2 * 0.5f), (double)(oy + dy2 * r + yay * w2 * 0.5f), (double)(oz + dz2 * r + yaz * w2 * 0.5f)), u1, v1, al2, lmap);
            this.decoVert(b.m_5483_((double)(ox + dx2 * r + yax * -w2 * 0.5f), (double)(oy + dy2 * r + yay * -w2 * 0.5f), (double)(oz + dz2 * r + yaz * -w2 * 0.5f)), u1, v0, al2, lmap);
            this.decoVert(b.m_5483_((double)(ox + dx1 * r + yax * -w1 * 0.5f), (double)(oy + dy1 * r + yay * -w1 * 0.5f), (double)(oz + dz1 * r + yaz * -w1 * 0.5f)), u0, v0, al1, lmap);
            this.decoVert(b.m_5483_((double)(ox + dx1 * r + yax * w1 * 0.5f), (double)(oy + dy1 * r + yay * w1 * 0.5f), (double)(oz + dz1 * r + yaz * w1 * 0.5f)), u0, v1, al1, lmap);
            this.decoVert(b.m_5483_((double)(ox + dx2 * r + yax * -w2), (double)(oy + dy2 * r + yay * -w2), (double)(oz + dz2 * r + yaz * -w2)), u1, v1, al2, lmap);
            this.decoVert(b.m_5483_((double)(ox + dx2 * r + yax * w2), (double)(oy + dy2 * r + yay * w2), (double)(oz + dz2 * r + yaz * w2)), u1, v0, al2, lmap);
            this.decoVert(b.m_5483_((double)(ox + dx1 * r + yax * w1), (double)(oy + dy1 * r + yay * w1), (double)(oz + dz1 * r + yaz * w1)), u0, v0, al1, lmap);
            this.decoVert(b.m_5483_((double)(ox + dx1 * r + yax * -w1), (double)(oy + dy1 * r + yay * -w1), (double)(oz + dz1 * r + yaz * -w1)), u0, v1, al1, lmap);
        }
    }
}

