/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import elucent.eidolon.common.entity.NecromancerEntity;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.AbstractIllager;
import org.jetbrains.annotations.NotNull;

public class NecromancerModel
extends EntityModel<NecromancerEntity> {
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart arms;
    private final ModelPart leftArm;
    private final ModelPart rightArm;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;

    public NecromancerModel(ModelPart root) {
        this.body = root.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.arms = this.body.m_171324_("arms");
        this.leftArm = this.body.m_171324_("left_arm");
        this.rightArm = this.body.m_171324_("right_arm");
        this.leftLeg = this.body.m_171324_("left_leg");
        this.rightLeg = this.body.m_171324_("right_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171488_(-4.0f, -24.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition clothing = body.m_171599_("clothing", CubeListBuilder.m_171558_().m_171514_(0, 38).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 20.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)-24.0f, (float)0.0f));
        PartDefinition left_leg = body.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)-12.0f, (float)0.0f));
        PartDefinition right_leg = body.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)-12.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(32, 0).m_171488_(-4.0f, -12.0f, -4.0f, 8.0f, 12.0f, 8.0f, new CubeDeformation(0.45f)).m_171514_(24, 0).m_171488_(-1.0f, -3.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-24.0f, (float)0.0f));
        PartDefinition arms = body.m_171599_("arms", CubeListBuilder.m_171558_().m_171514_(40, 38).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(44, 22).m_171480_().m_171488_(4.0f, -4.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(44, 22).m_171488_(-8.0f, -4.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-20.0f, (float)-2.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm = body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-6.0f, (float)-24.0f, (float)0.0f));
        PartDefinition left_arm = body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)6.0f, (float)-24.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(@NotNull NecromancerEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean flag;
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.arms.f_104203_ = -0.75f;
        if (this.f_102609_) {
            this.rightArm.f_104203_ = -0.62831855f;
            this.rightArm.f_104204_ = 0.0f;
            this.rightArm.f_104205_ = 0.0f;
            this.leftArm.f_104203_ = -0.62831855f;
            this.leftArm.f_104204_ = 0.0f;
            this.leftArm.f_104205_ = 0.0f;
            this.rightLeg.f_104203_ = -1.4137167f;
            this.rightLeg.f_104204_ = 0.31415927f;
            this.rightLeg.f_104205_ = 0.07853982f;
            this.leftLeg.f_104203_ = -1.4137167f;
            this.leftLeg.f_104204_ = -0.31415927f;
            this.leftLeg.f_104205_ = -0.07853982f;
        } else {
            this.rightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
            this.rightArm.f_104204_ = 0.0f;
            this.rightArm.f_104205_ = 0.0f;
            this.leftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
            this.leftArm.f_104204_ = 0.0f;
            this.leftArm.f_104205_ = 0.0f;
            this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
            this.rightLeg.f_104204_ = 0.0f;
            this.rightLeg.f_104205_ = 0.0f;
            this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
            this.leftLeg.f_104204_ = 0.0f;
            this.leftLeg.f_104205_ = 0.0f;
        }
        AbstractIllager.IllagerArmPose armpose = entity.m_6768_();
        if (armpose == AbstractIllager.IllagerArmPose.ATTACKING) {
            if (entity.m_21205_().m_41619_()) {
                AnimationUtils.m_102102_((ModelPart)this.leftArm, (ModelPart)this.rightArm, (boolean)true, (float)this.f_102608_, (float)ageInTicks);
            } else {
                AnimationUtils.m_102091_((ModelPart)this.rightArm, (ModelPart)this.leftArm, (Mob)entity, (float)this.f_102608_, (float)ageInTicks);
            }
        } else if (armpose == AbstractIllager.IllagerArmPose.SPELLCASTING) {
            this.rightArm.f_104202_ = 0.0f;
            this.rightArm.f_104200_ = -5.0f;
            this.leftArm.f_104202_ = 0.0f;
            this.leftArm.f_104200_ = 5.0f;
            this.rightArm.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
            this.leftArm.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
            this.rightArm.f_104205_ = 2.3561945f;
            this.leftArm.f_104205_ = -2.3561945f;
            this.rightArm.f_104204_ = 0.0f;
            this.leftArm.f_104204_ = 0.0f;
        } else if (armpose == AbstractIllager.IllagerArmPose.BOW_AND_ARROW) {
            this.rightArm.f_104204_ = -0.1f + this.head.f_104204_;
            this.rightArm.f_104203_ = -1.5707964f + this.head.f_104203_;
            this.leftArm.f_104203_ = -0.9424779f + this.head.f_104203_;
            this.leftArm.f_104204_ = this.head.f_104204_ - 0.4f;
            this.leftArm.f_104205_ = 1.5707964f;
        } else if (armpose == AbstractIllager.IllagerArmPose.CROSSBOW_HOLD) {
            AnimationUtils.m_102097_((ModelPart)this.rightArm, (ModelPart)this.leftArm, (ModelPart)this.head, (boolean)true);
        } else if (armpose == AbstractIllager.IllagerArmPose.CROSSBOW_CHARGE) {
            AnimationUtils.m_102086_((ModelPart)this.rightArm, (ModelPart)this.leftArm, (LivingEntity)entity, (boolean)true);
        } else if (armpose == AbstractIllager.IllagerArmPose.CELEBRATING) {
            this.rightArm.f_104202_ = 0.0f;
            this.rightArm.f_104200_ = -5.0f;
            this.rightArm.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.05f;
            this.rightArm.f_104205_ = 2.670354f;
            this.rightArm.f_104204_ = 0.0f;
            this.leftArm.f_104202_ = 0.0f;
            this.leftArm.f_104200_ = 5.0f;
            this.leftArm.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.05f;
            this.leftArm.f_104205_ = -2.3561945f;
            this.leftArm.f_104204_ = 0.0f;
        }
        this.arms.f_104207_ = flag = armpose == AbstractIllager.IllagerArmPose.CROSSED;
        this.leftArm.f_104207_ = !flag;
        this.rightArm.f_104207_ = !flag;
    }

    public void m_7695_(@NotNull PoseStack matrixStack, @NotNull VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104301_(matrixStack, buffer, packedLight, packedOverlay);
    }

    public void setRotationAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.f_104203_ = x;
        modelRenderer.f_104204_ = y;
        modelRenderer.f_104205_ = z;
    }
}

