/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.capability;

import elucent.eidolon.capability.IReputation;
import elucent.eidolon.capability.ReputationEntry;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;

public class ReputationImpl
implements IReputation,
INBTSerializable<CompoundTag> {
    final Map<UUID, Map<ResourceLocation, ReputationEntry>> reputationMap = new HashMap<UUID, Map<ResourceLocation, ReputationEntry>>();
    final Map<UUID, Map<ResourceLocation, Long>> prayerTimes = new HashMap<UUID, Map<ResourceLocation, Long>>();

    @Override
    public double getReputation(UUID player, ResourceLocation deity) {
        return this.getReputationMap((UUID)player).computeIfAbsent((ResourceLocation)deity, (Function<ResourceLocation, ReputationEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getReputation$0(net.minecraft.resources.ResourceLocation ), (Lnet/minecraft/resources/ResourceLocation;)Lelucent/eidolon/capability/ReputationEntry;)()).reputation;
    }

    @Override
    public void addReputation(UUID player, ResourceLocation deity, double amount) {
        ReputationEntry entry = this.getReputationMap(player).computeIfAbsent(deity, k -> new ReputationEntry());
        if (entry.lock == null) {
            entry.reputation += amount;
        }
    }

    @Override
    public void subtractReputation(UUID player, ResourceLocation deity, double amount) {
        ReputationEntry entry = this.getReputationMap(player).computeIfAbsent(deity, k -> new ReputationEntry());
        entry.reputation = Math.max(0.0, entry.reputation - amount);
    }

    @Override
    public void setReputation(UUID player, ResourceLocation deity, double amount) {
        ReputationEntry entry = this.getReputationMap(player).computeIfAbsent(deity, k -> new ReputationEntry());
        if (entry.lock == null || amount < 0.0) {
            double prev = entry.reputation;
            entry.reputation = amount;
        }
    }

    @Override
    public boolean isLocked(UUID player, ResourceLocation deity) {
        return this.getReputationMap((UUID)player).computeIfAbsent((ResourceLocation)deity, (Function<ResourceLocation, ReputationEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$isLocked$4(net.minecraft.resources.ResourceLocation ), (Lnet/minecraft/resources/ResourceLocation;)Lelucent/eidolon/capability/ReputationEntry;)()).lock != null;
    }

    @Override
    public boolean hasLock(UUID player, ResourceLocation deity, ResourceLocation lock) {
        ResourceLocation l = this.getReputationMap((UUID)player).computeIfAbsent((ResourceLocation)deity, (Function<ResourceLocation, ReputationEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$hasLock$5(net.minecraft.resources.ResourceLocation ), (Lnet/minecraft/resources/ResourceLocation;)Lelucent/eidolon/capability/ReputationEntry;)()).lock;
        return l != null && l.equals((Object)lock);
    }

    @Override
    public void lock(UUID player, ResourceLocation deity, ResourceLocation key) {
        this.getReputationMap((UUID)player).computeIfAbsent((ResourceLocation)deity, (Function<ResourceLocation, ReputationEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$lock$6(net.minecraft.resources.ResourceLocation ), (Lnet/minecraft/resources/ResourceLocation;)Lelucent/eidolon/capability/ReputationEntry;)()).lock = key;
    }

    @Override
    public boolean unlock(UUID player, ResourceLocation deity, ResourceLocation key) {
        ReputationEntry entry = this.getReputationMap(player).computeIfAbsent(deity, k -> new ReputationEntry());
        if (entry.lock != null && entry.lock.equals((Object)key)) {
            entry.lock = null;
            return true;
        }
        return false;
    }

    @Override
    public void pray(UUID player, ResourceLocation spell, long time) {
        this.getPrayerTimes().computeIfAbsent(player, p -> new HashMap()).put(spell, time);
    }

    @Override
    public boolean canPray(UUID player, ResourceLocation spell, long time) {
        Map times = this.getPrayerTimes().computeIfAbsent(player, p -> new HashMap());
        return !times.containsKey(spell) || (Long)times.get(spell) < time - 21000L;
    }

    @Override
    public Map<UUID, Map<ResourceLocation, Long>> getPrayerTimes() {
        return this.prayerTimes;
    }

    @Override
    public Map<UUID, Map<ResourceLocation, ReputationEntry>> getReputationMap() {
        return this.reputationMap;
    }

    public CompoundTag serializeNBT() {
        CompoundTag data = new CompoundTag();
        CompoundTag reps = new CompoundTag();
        for (Map.Entry<UUID, Map<ResourceLocation, ReputationEntry>> e : this.getReputationMap().entrySet()) {
            CompoundTag tag = new CompoundTag();
            for (Map.Entry<ResourceLocation, ReputationEntry> e2 : e.getValue().entrySet()) {
                CompoundTag entry = new CompoundTag();
                entry.m_128347_("rep", e2.getValue().reputation);
                if (e2.getValue().lock != null) {
                    entry.m_128359_("lock", e2.getValue().lock.toString());
                }
                tag.m_128365_(e2.getKey().toString(), (Tag)entry);
            }
            reps.m_128365_(e.getKey().toString(), (Tag)tag);
        }
        CompoundTag times = new CompoundTag();
        for (Map.Entry<UUID, Map<ResourceLocation, Long>> e : this.getPrayerTimes().entrySet()) {
            CompoundTag nbt = new CompoundTag();
            for (Map.Entry<ResourceLocation, Long> e2 : e.getValue().entrySet()) {
                nbt.m_128356_(e2.getKey().toString(), e2.getValue().longValue());
            }
            times.m_128365_(e.getKey().toString(), (Tag)nbt);
        }
        data.m_128365_("reps", (Tag)reps);
        data.m_128365_("times", (Tag)times);
        return data;
    }

    public void deserializeNBT(CompoundTag nbt) {
        UUID uuid;
        this.getReputationMap().clear();
        if (nbt.m_128441_("reps")) {
            CompoundTag reps = nbt.m_128469_("reps");
            for (String uuidString : reps.m_128431_()) {
                uuid = UUID.fromString(uuidString);
                CompoundTag tag = reps.m_128469_(uuidString);
                for (String deity : tag.m_128431_()) {
                    CompoundTag entry = tag.m_128469_(deity);
                    this.setReputation(uuid, new ResourceLocation(deity), entry.m_128459_("rep"));
                    if (!entry.m_128441_("lock")) continue;
                    this.lock(uuid, new ResourceLocation(deity), new ResourceLocation(entry.m_128461_("lock")));
                }
            }
        }
        if (nbt.m_128441_("times")) {
            CompoundTag times = nbt.m_128469_("times");
            for (String uuidString : times.m_128431_()) {
                uuid = UUID.fromString(uuidString);
                CompoundTag spelltimes = times.m_128469_(uuidString);
                for (String rl : spelltimes.m_128431_()) {
                    this.pray(uuid, new ResourceLocation(rl), spelltimes.m_128454_(rl));
                }
            }
        }
    }

    private static /* synthetic */ ReputationEntry lambda$lock$6(ResourceLocation k) {
        return new ReputationEntry();
    }

    private static /* synthetic */ ReputationEntry lambda$hasLock$5(ResourceLocation k) {
        return new ReputationEntry();
    }

    private static /* synthetic */ ReputationEntry lambda$isLocked$4(ResourceLocation k) {
        return new ReputationEntry();
    }

    private static /* synthetic */ ReputationEntry lambda$getReputation$0(ResourceLocation k) {
        return new ReputationEntry();
    }
}

