/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.api.ritual;

import elucent.eidolon.api.ritual.IRequirement;
import elucent.eidolon.api.ritual.RequirementInfo;
import elucent.eidolon.util.ColorUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.AABB;

public abstract class Ritual
implements Cloneable {
    ResourceLocation name = null;
    final int color;
    final ResourceLocation symbol;
    final List<IRequirement> stepRequirements = new ArrayList<IRequirement>();
    final List<IRequirement> continuousRequirements = new ArrayList<IRequirement>();

    public Ritual(ResourceLocation symbol, float r, float g, float b) {
        this.symbol = symbol;
        this.color = ColorUtil.packColor(255, (int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f));
    }

    public Ritual(ResourceLocation symbol, int color) {
        this.symbol = symbol;
        this.color = color;
    }

    public Ritual(ResourceLocation symbol, int color, ResourceLocation name) {
        this.symbol = symbol;
        this.color = color;
        this.name = name;
    }

    public ResourceLocation getSymbol() {
        return this.symbol;
    }

    public Ritual setRegistryName(String domain, String path) {
        this.name = new ResourceLocation(domain, path);
        return this;
    }

    public Ritual setRegistryName(ResourceLocation name) {
        this.name = name;
        return this;
    }

    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public Ritual addRequirement(IRequirement requirement) {
        this.stepRequirements.add(requirement);
        return this;
    }

    public Ritual addRequirements(List<IRequirement> requirements) {
        this.stepRequirements.addAll(requirements);
        return this;
    }

    public Ritual addInvariant(IRequirement requirement) {
        this.continuousRequirements.add(requirement);
        return this;
    }

    public Ritual addInvariants(List<IRequirement> requirements) {
        this.continuousRequirements.addAll(requirements);
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public float getRed() {
        return (float)ColorUtil.getRed(this.color) / 255.0f;
    }

    public float getGreen() {
        return (float)ColorUtil.getGreen(this.color) / 255.0f;
    }

    public float getBlue() {
        return (float)ColorUtil.getBlue(this.color) / 255.0f;
    }

    public List<IRequirement> getRequirements() {
        return this.stepRequirements;
    }

    public List<IRequirement> getInvariants() {
        return this.continuousRequirements;
    }

    public Ritual clone() {
        return this.cloneRitual().addInvariants(this.getInvariants()).setRegistryName(this.getRegistryName());
    }

    public abstract Ritual cloneRitual();

    public SetupResult setup(Level world, BlockPos pos, int step) {
        if (step >= this.stepRequirements.size()) {
            return SetupResult.SUCCEED;
        }
        for (IRequirement req : this.continuousRequirements) {
            RequirementInfo info = req.isMet(this, world, pos);
            if (!info.isMet()) {
                return SetupResult.FAIL;
            }
            req.whenMet(this, world, pos, info);
        }
        IRequirement req = this.stepRequirements.get(step);
        RequirementInfo info = req.isMet(this, world, pos);
        if (!info.isMet()) {
            return SetupResult.FAIL;
        }
        req.whenMet(this, world, pos, info);
        return SetupResult.PASS;
    }

    public AABB getSearchBounds(BlockPos pos) {
        return Ritual.getDefaultBounds(pos);
    }

    public static AABB getDefaultBounds(BlockPos pos) {
        return new AABB((double)(pos.m_123341_() - 8), (double)(pos.m_123342_() - 6), (double)(pos.m_123343_() - 8), (double)(pos.m_123341_() + 9), (double)(pos.m_123342_() + 11), (double)(pos.m_123343_() + 9));
    }

    public RitualResult tick(Level world, BlockPos pos) {
        return RitualResult.PASS;
    }

    public RitualResult start(Level world, BlockPos pos) {
        return RitualResult.PASS;
    }

    public static <T> List<T> getTilesWithinAABB(Class<T> type, Level world, AABB bb) {
        ArrayList<T> tileList = new ArrayList<T>();
        for (int i = (int)Math.floor(bb.f_82288_); i < (int)Math.ceil(bb.f_82291_) + 16; i += 16) {
            for (int j = (int)Math.floor(bb.f_82290_); j < (int)Math.ceil(bb.f_82293_) + 16; j += 16) {
                ChunkAccess c = world.m_46865_(new BlockPos(i, 0, j));
                Set tiles = c.m_5928_();
                for (BlockPos p : tiles) {
                    BlockEntity t;
                    if (!bb.m_82393_((double)p.m_123341_() + 0.5, (double)p.m_123342_() + 0.5, (double)p.m_123343_() + 0.5) || !type.isInstance(t = world.m_7702_(p))) continue;
                    tileList.add(type.cast(t));
                }
            }
        }
        return tileList;
    }

    public static enum SetupResult {
        FAIL,
        PASS,
        SUCCEED;

    }

    public static enum RitualResult {
        PASS,
        TERMINATE;

    }
}

