/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.api.ritual;

import elucent.eidolon.api.ritual.IRequirement;
import elucent.eidolon.api.ritual.RequirementInfo;
import elucent.eidolon.api.ritual.Ritual;
import elucent.eidolon.network.Networking;
import elucent.eidolon.network.RitualConsumePacket;
import elucent.eidolon.registries.Registry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class HealthRequirement
implements IRequirement {
    final float health;

    public float getHealth() {
        return this.health;
    }

    public HealthRequirement(float health) {
        this.health = health;
    }

    @Override
    public RequirementInfo isMet(Ritual ritual, Level world, BlockPos pos) {
        if (this.health <= 0.0f) {
            return RequirementInfo.TRUE;
        }
        List entities = world.m_6443_(Mob.class, Ritual.getDefaultBounds(pos), entity -> !entity.m_21222_());
        List players = world.m_45976_(Player.class, Ritual.getDefaultBounds(pos));
        ArrayList targets = new ArrayList();
        targets.addAll(entities);
        targets.addAll(players);
        float acc = 0.0f;
        for (LivingEntity target : targets) {
            if (!((acc += target.m_21223_()) >= this.health)) continue;
            return RequirementInfo.TRUE;
        }
        return RequirementInfo.FALSE;
    }

    @Override
    public void whenMet(Ritual ritual, Level world, BlockPos pos, RequirementInfo info) {
        if (this.health <= 0.0f) {
            return;
        }
        List entities = world.m_6443_(Mob.class, Ritual.getDefaultBounds(pos), entity -> !entity.m_21222_());
        List players = world.m_45976_(Player.class, Ritual.getDefaultBounds(pos));
        ArrayList targets = new ArrayList();
        targets.addAll(entities);
        targets.addAll(players);
        float acc = 0.0f;
        for (LivingEntity target : targets) {
            float targetHealth = target.m_21223_();
            target.m_6469_(Registry.RITUAL_DAMAGE.source((LevelAccessor)world), Math.min(this.health - acc, targetHealth));
            acc += targetHealth;
            if (!world.f_46443_) {
                Networking.sendToTracking(world, pos, new RitualConsumePacket(target.m_20183_(), pos, ritual.getRed(), ritual.getGreen(), ritual.getBlue()));
            }
            if (!(acc >= this.health)) continue;
            return;
        }
    }
}

