/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks;

import de.maxhenkel.easyvillagers.ItemTileEntityCache;
import de.maxhenkel.easyvillagers.blocks.ModBlocks;
import de.maxhenkel.easyvillagers.blocks.TraderBlock;
import de.maxhenkel.easyvillagers.blocks.VillagerBlockBase;
import de.maxhenkel.easyvillagers.blocks.tileentity.FarmerTileentity;
import de.maxhenkel.easyvillagers.corelib.block.IItemBlock;
import de.maxhenkel.easyvillagers.corelib.blockentity.SimpleBlockEntityTicker;
import de.maxhenkel.easyvillagers.corelib.client.CustomRendererBlockItem;
import de.maxhenkel.easyvillagers.corelib.client.ItemRenderer;
import de.maxhenkel.easyvillagers.corelib.item.ItemUtils;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import de.maxhenkel.easyvillagers.gui.OutputContainer;
import de.maxhenkel.easyvillagers.items.VillagerItem;
import de.maxhenkel.easyvillagers.items.render.FarmerItemRenderer;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FarmerBlock
extends VillagerBlockBase
implements EntityBlock,
IItemBlock {
    public FarmerBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60978_(2.5f).m_60918_(SoundType.f_56743_).m_60955_());
    }

    @Override
    public Item toItem() {
        return new CustomRendererBlockItem(this, new Item.Properties()){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public ItemRenderer createItemRenderer() {
                return new FarmerItemRenderer();
            }
        };
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter blockGetter, List<Component> components, TooltipFlag tooltipFlag) {
        super.m_5871_(stack, blockGetter, components, tooltipFlag);
        FarmerTileentity trader = ItemTileEntityCache.getTileEntity(stack, () -> new FarmerTileentity(BlockPos.f_121853_, ((TraderBlock)ModBlocks.TRADER.get()).m_49966_()));
        EasyVillagerEntity villager = trader.getVillagerEntity();
        if (villager != null) {
            components.add(villager.getAdvancedName());
        }
    }

    public InteractionResult m_6227_(final BlockState state, final Level worldIn, final BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(handIn);
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (!(tileEntity instanceof FarmerTileentity)) {
            return super.m_6227_(state, worldIn, pos, player, handIn, hit);
        }
        final FarmerTileentity farmer = (FarmerTileentity)tileEntity;
        if (!farmer.hasVillager() && heldItem.m_41720_() instanceof VillagerItem) {
            farmer.setVillager(heldItem.m_41777_());
            ItemUtils.decrItemStack(heldItem, player);
            VillagerBlockBase.playVillagerSound(worldIn, pos, SoundEvents.f_12509_);
            return InteractionResult.SUCCESS;
        }
        if (farmer.getCrop() == null && farmer.isValidSeed(heldItem.m_41720_())) {
            Item seed = heldItem.m_41720_();
            farmer.setCrop(seed);
            ItemUtils.decrItemStack(heldItem, player);
            EasyVillagerEntity villagerEntity = farmer.getVillagerEntity();
            if (villagerEntity != null) {
                VillagerBlockBase.playVillagerSound(worldIn, pos, SoundEvents.f_12567_);
            }
            VillagerBlockBase.playVillagerSound(worldIn, pos, SoundEvents.f_11839_);
            return InteractionResult.SUCCESS;
        }
        if (player.m_6144_() && farmer.getCrop() != null) {
            ItemStack blockStack = new ItemStack((ItemLike)farmer.removeSeed());
            if (heldItem.m_41619_()) {
                player.m_21008_(handIn, blockStack);
            } else if (!player.m_150109_().m_36054_(blockStack)) {
                Direction direction = (Direction)state.m_61143_((Property)FACING);
                Containers.m_18992_((Level)worldIn, (double)((double)(direction.m_122429_() + pos.m_123341_()) + 0.5), (double)((double)pos.m_123342_() + 0.5), (double)((double)(direction.m_122431_() + pos.m_123343_()) + 0.5), (ItemStack)blockStack);
            }
            if (farmer.hasVillager()) {
                VillagerBlockBase.playVillagerSound(worldIn, pos, SoundEvents.f_12507_);
            }
            return InteractionResult.SUCCESS;
        }
        if (player.m_6144_() && farmer.hasVillager()) {
            ItemStack stack = farmer.removeVillager();
            if (heldItem.m_41619_()) {
                player.m_21008_(handIn, stack);
            } else if (!player.m_150109_().m_36054_(stack)) {
                Direction direction = (Direction)state.m_61143_((Property)FACING);
                Containers.m_18992_((Level)worldIn, (double)((double)(direction.m_122429_() + pos.m_123341_()) + 0.5), (double)((double)pos.m_123342_() + 0.5), (double)((double)(direction.m_122431_() + pos.m_123343_()) + 0.5), (ItemStack)stack);
            }
            VillagerBlockBase.playVillagerSound(worldIn, pos, SoundEvents.f_12504_);
            return InteractionResult.SUCCESS;
        }
        player.m_5893_(new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237115_((String)state.m_60734_().m_7705_());
            }

            @Nullable
            public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
                return new OutputContainer(id, playerInventory, farmer.getOutputInventory(), ContainerLevelAccess.m_39289_((Level)worldIn, (BlockPos)pos), () -> ModBlocks.FARMER.get());
            }
        });
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level1, BlockState state, BlockEntityType<T> type) {
        return new SimpleBlockEntityTicker();
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new FarmerTileentity(blockPos, blockState);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float m_7749_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }
}

