/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.allbrick;

import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.block.decorative.AllBrickStairBlock;
import com.ldtteam.domumornamentum.block.decorative.ShingleBlock;
import com.ldtteam.domumornamentum.datagen.MateriallyTexturedModelBuilder;
import com.ldtteam.domumornamentum.datagen.utils.ModelBuilderUtils;
import java.util.EnumMap;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class AllBrickStairBlockStateProvider
extends BlockStateProvider {
    public AllBrickStairBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen.getPackOutput(), "domum_ornamentum", exFileHelper);
    }

    protected void registerStatesAndModels() {
        ModBlocks.getInstance().getAllBrickStairBlocks().forEach(this::registerStatesAndModelsFor);
    }

    private void registerStatesAndModelsFor(AllBrickStairBlock allBrickStairBlock) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(allBrickStairBlock);
        if (allBrickStairBlock.getRegistryName() == null) {
            return;
        }
        EnumMap<StairsShape, ModelFile> blockModels = new EnumMap<StairsShape, ModelFile>(StairsShape.class);
        for (Direction facingValue : StairBlock.f_56841_.m_6908_()) {
            for (StairsShape shapeValue : ShingleBlock.SHAPE.m_6908_()) {
                for (Half halfValue : StairBlock.f_56842_.m_6908_()) {
                    String shapeType = AllBrickStairBlockStateProvider.getTypeFromShape(shapeValue);
                    ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(blockModels.computeIfAbsent(shapeValue, shape -> ((MateriallyTexturedModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/allbrick/" + allBrickStairBlock.getRegistryName().m_135815_() + shapeValue.name().toLowerCase(), this.modLoc("block/allbrick/" + allBrickStairBlock.getRegistryName().m_135815_() + shapeType + "_spec"))).customLoader(MateriallyTexturedModelBuilder::new)).end())).rotationX(halfValue == Half.TOP ? 180 : 0).rotationY(this.getYFromFacing(facingValue) + this.getYFromShape(shapeValue) + this.getYFromHalf(halfValue, shapeValue)).addModel()).condition((Property)StairBlock.f_56841_, (Comparable[])new Direction[]{facingValue}).condition((Property)StairBlock.f_56843_, (Comparable[])new StairsShape[]{shapeValue}).condition((Property)StairBlock.f_56842_, (Comparable[])new Half[]{halfValue}).end();
                }
            }
        }
        ItemModelBuilder itemModelBuilder = (ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(allBrickStairBlock.getRegistryName().m_135815_())).parent((ModelFile)blockModels.get(StairsShape.STRAIGHT));
        ModelBuilderUtils.applyDefaultItemTransforms(itemModelBuilder);
    }

    @NotNull
    public String m_6055_() {
        return "All Brick Stair BlockStates Provider";
    }

    private int getYFromHalf(Half half, StairsShape shape) {
        if (half == Half.TOP) {
            if (shape == StairsShape.STRAIGHT) {
                return 180;
            }
            return 270;
        }
        return 180;
    }

    private int getYFromShape(StairsShape shape) {
        return switch (shape) {
            default -> 0;
            case StairsShape.OUTER_LEFT, StairsShape.INNER_LEFT -> -90;
        };
    }

    private int getYFromFacing(Direction facing) {
        return switch (facing) {
            default -> 180;
            case Direction.SOUTH -> 270;
            case Direction.WEST -> 0;
            case Direction.NORTH -> 90;
        };
    }

    private static String getTypeFromShape(StairsShape shape) {
        return switch (shape) {
            case StairsShape.INNER_LEFT, StairsShape.INNER_RIGHT -> "_inner";
            case StairsShape.OUTER_LEFT, StairsShape.OUTER_RIGHT -> "_outer";
            default -> "";
        };
    }
}

