/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.shingle.slab;

import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.block.decorative.ShingleSlabBlock;
import com.ldtteam.domumornamentum.block.types.ShingleSlabShapeType;
import com.ldtteam.domumornamentum.datagen.MateriallyTexturedModelBuilder;
import com.ldtteam.domumornamentum.datagen.utils.ModelBuilderUtils;
import java.util.EnumMap;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class ShingleSlabBlockStateProvider
extends BlockStateProvider {
    public ShingleSlabBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen.getPackOutput(), "domum_ornamentum", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.createBlockstateFile(ModBlocks.getInstance().getShingleSlab());
    }

    private void createBlockstateFile(ShingleSlabBlock shingle) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)shingle);
        EnumMap<ShingleSlabShapeType, ModelFile> models = new EnumMap<ShingleSlabShapeType, ModelFile>(ShingleSlabShapeType.class);
        for (Direction facingValue : StairBlock.f_56841_.m_6908_()) {
            for (ShingleSlabShapeType shapeValue : ShingleSlabBlock.SHAPE.m_6908_()) {
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(models.computeIfAbsent(shapeValue, shape -> ((MateriallyTexturedModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/shingle_slab/" + shapeValue.name().toLowerCase(), this.modLoc("block/shingle_slab/shingle_slab_" + shapeValue.name().toLowerCase() + "_spec"))).customLoader(MateriallyTexturedModelBuilder::new)).end())).rotationY(this.getYFromFacing(facingValue)).addModel()).condition((Property)StairBlock.f_56841_, (Comparable[])new Direction[]{facingValue}).condition(ShingleSlabBlock.SHAPE, (Comparable[])new ShingleSlabShapeType[]{shapeValue}).end();
            }
        }
        ItemModelBuilder itemModelBuilder = (ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(shingle.getRegistryName().m_135815_())).parent((ModelFile)models.get((Object)ShingleSlabShapeType.TOP));
        ModelBuilderUtils.applyDefaultItemTransforms(itemModelBuilder);
    }

    @NotNull
    public String m_6055_() {
        return "Shingle Slabs BlockStates Provider";
    }

    private int getYFromFacing(Direction facing) {
        return switch (facing) {
            default -> 0;
            case Direction.EAST -> 90;
            case Direction.SOUTH -> 180;
            case Direction.WEST -> 270;
        };
    }
}

