/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.machines.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import mcjty.deepresonance.modules.machines.MachinesModule;
import mcjty.deepresonance.modules.machines.block.LaserTileEntity;
import mcjty.deepresonance.setup.ClientSetup;
import mcjty.lib.client.DelayedRenderer;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.client.RenderSettings;
import mcjty.lib.varia.OrientationTools;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class LaserRenderer
implements BlockEntityRenderer<LaserTileEntity> {
    public static final Vec3 START = new Vec3(0.5, 0.5, 0.5);

    public LaserRenderer(BlockEntityRendererProvider.Context context) {
    }

    public static void register() {
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)MachinesModule.TYPE_LASER.get()), LaserRenderer::new);
    }

    public void render(@Nonnull LaserTileEntity tileEntity, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        DelayedRenderer.addRender((RenderType)RenderType.m_110466_(), (BlockPos)tileEntity.m_58899_(), (stack, buf) -> {
            int color = (Integer)tileEntity.m_58900_().m_61143_((Property)LaserTileEntity.COLOR);
            this.renderInternal(tileEntity.m_58899_(), color, (PoseStack)stack, (VertexConsumer)buf);
        });
    }

    private void renderInternal(BlockPos pos, int color, PoseStack matrixStack, VertexConsumer builder) {
        if (color != 0) {
            Direction direction = OrientationTools.getOrientationHoriz((BlockState)Minecraft.m_91087_().f_91073_.m_8055_(pos));
            float destX = 0.5f + (float)direction.m_122429_() * 2.5f;
            float destY = 0.5f;
            float destZ = 0.5f + (float)direction.m_122431_() * 2.5f;
            ResourceLocation laser = switch (color) {
                case 1 -> ClientSetup.BLUELASER;
                case 2 -> ClientSetup.REDLASER;
                case 3 -> ClientSetup.GREENLASER;
                case 4 -> ClientSetup.YELLOWLASER;
                default -> null;
            };
            int tex = pos.m_123341_();
            int tey = pos.m_123342_();
            int tez = pos.m_123343_();
            Vec3 player = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_().m_82520_((double)(-tex), (double)(-tey), (double)(-tez));
            Vec3 end = new Vec3((double)destX, (double)destY, (double)destZ);
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(laser);
            matrixStack.m_85836_();
            RenderSettings settingsLaser = RenderSettings.builder().width(0.25f).alpha(128).build();
            RenderHelper.drawBeam((PoseStack)matrixStack, (VertexConsumer)builder, (TextureAtlasSprite)sprite, (Vec3)START, (Vec3)end, (Vec3)player, (RenderSettings)settingsLaser);
            matrixStack.m_85849_();
        }
    }
}

