/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.network;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import tfar.dankstorage.network.client.S2CContentsForDisplayPacket;
import tfar.dankstorage.network.client.S2CInitialSyncContainerPacket;
import tfar.dankstorage.network.client.S2CModPacket;
import tfar.dankstorage.network.client.S2CSendExtendedSlotChangePacket;
import tfar.dankstorage.network.client.S2CSendGhostSlotPacket;
import tfar.dankstorage.network.client.S2CSyncSelectedDankItemPacket;
import tfar.dankstorage.network.server.C2SButtonPacket;
import tfar.dankstorage.network.server.C2SLockSlotPacket;
import tfar.dankstorage.network.server.C2SModPacket;
import tfar.dankstorage.network.server.C2SRequestContentsPacket;
import tfar.dankstorage.network.server.C2SScrollSlotPacket;
import tfar.dankstorage.network.server.C2SSetFrequencyPacket;

public class DankPacketHandlerForge {
    public static SimpleChannel INSTANCE;

    public static void registerMessages() {
        INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("dankstorage", "dankstorage"), () -> "1.0", s -> true, s -> true);
        int i = 0;
        INSTANCE.registerMessage(i++, C2SScrollSlotPacket.class, C2SScrollSlotPacket::write, C2SScrollSlotPacket::new, DankPacketHandlerForge.wrapC2S());
        INSTANCE.registerMessage(i++, C2SLockSlotPacket.class, C2SLockSlotPacket::write, C2SLockSlotPacket::new, DankPacketHandlerForge.wrapC2S());
        INSTANCE.registerMessage(i++, C2SButtonPacket.class, C2SButtonPacket::write, C2SButtonPacket::new, DankPacketHandlerForge.wrapC2S());
        INSTANCE.registerMessage(i++, C2SSetFrequencyPacket.class, C2SSetFrequencyPacket::write, C2SSetFrequencyPacket::new, DankPacketHandlerForge.wrapC2S());
        INSTANCE.registerMessage(i++, C2SRequestContentsPacket.class, C2SRequestContentsPacket::write, C2SRequestContentsPacket::new, DankPacketHandlerForge.wrapC2S());
        INSTANCE.registerMessage(i++, S2CSendExtendedSlotChangePacket.class, S2CSendExtendedSlotChangePacket::write, S2CSendExtendedSlotChangePacket::new, DankPacketHandlerForge.wrapS2C());
        INSTANCE.registerMessage(i++, S2CSendGhostSlotPacket.class, S2CSendGhostSlotPacket::write, S2CSendGhostSlotPacket::new, DankPacketHandlerForge.wrapS2C());
        INSTANCE.registerMessage(i++, S2CSyncSelectedDankItemPacket.class, S2CSyncSelectedDankItemPacket::write, S2CSyncSelectedDankItemPacket::new, DankPacketHandlerForge.wrapS2C());
        INSTANCE.registerMessage(i++, S2CInitialSyncContainerPacket.class, S2CInitialSyncContainerPacket::write, S2CInitialSyncContainerPacket::new, DankPacketHandlerForge.wrapS2C());
        INSTANCE.registerMessage(i++, S2CContentsForDisplayPacket.class, S2CContentsForDisplayPacket::write, S2CContentsForDisplayPacket::new, DankPacketHandlerForge.wrapS2C());
    }

    private static <MSG extends S2CModPacket> BiConsumer<MSG, Supplier<NetworkEvent.Context>> wrapS2C() {
        return (msg, contextSupplier) -> {
            ((NetworkEvent.Context)contextSupplier.get()).enqueueWork(msg::handleClient);
            ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
        };
    }

    private static <MSG extends C2SModPacket> BiConsumer<MSG, Supplier<NetworkEvent.Context>> wrapC2S() {
        return (msg, contextSupplier) -> {
            ServerPlayer player = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            ((NetworkEvent.Context)contextSupplier.get()).enqueueWork(() -> msg.handleServer(player));
            ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
        };
    }

    public static void sendContentsForDisplay(ServerPlayer player, NonNullList<ItemStack> stacks) {
        DankPacketHandlerForge.sendToClient(new S2CContentsForDisplayPacket(stacks), player);
    }

    public static <MSG> void sendToClient(MSG packet, ServerPlayer player) {
        INSTANCE.sendTo(packet, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static <MSG> void sendToServer(MSG packet) {
        INSTANCE.sendToServer(packet);
    }
}

