/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.world;

import net.minecraft.core.NonNullList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import tfar.dankstorage.ModTags;
import tfar.dankstorage.inventory.DankInterface;
import tfar.dankstorage.utils.DankStats;

public class DankInventoryForge
extends ItemStackHandler
implements DankInterface {
    public DankStats dankStats;
    protected NonNullList<ItemStack> ghostItems;
    protected int frequency;
    private boolean frequencyLocked = true;
    protected int textColor = -1;
    public MinecraftServer server;

    public DankInventoryForge(DankStats stats, int frequency) {
        super(stats.slots);
        this.dankStats = stats;
        this.ghostItems = NonNullList.m_122780_((int)stats.slots, (Object)ItemStack.f_41583_);
        this.frequency = frequency;
    }

    @Override
    public void setDankStats(DankStats dankStats) {
        this.dankStats = dankStats;
        this.setSize(dankStats.slots);
    }

    @Override
    public DankStats getDankStats() {
        return this.dankStats;
    }

    public void setSize(int size) {
        super.setSize(size);
        this.ghostItems = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
    }

    @Override
    public void setSizeDank(int size) {
        this.setSize(size);
    }

    @Override
    public void setItemsDank(NonNullList<ItemStack> stacks) {
        this.stacks = stacks;
    }

    @Override
    public void setGhostItems(NonNullList<ItemStack> ghostItems) {
        this.ghostItems = ghostItems;
    }

    @Override
    public int getContainerSizeDank() {
        return this.getSlots();
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (this.hasGhostItem(slot) && this.getGhostItem(slot).m_41720_() != stack.m_41720_()) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.dankStats.stacklimit;
    }

    public int getStackLimit(int slot, @NotNull ItemStack stack) {
        return this.getMaxStackSizeSensitive(stack);
    }

    @Override
    public NonNullList<ItemStack> getContents() {
        return this.stacks;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        boolean checkGhostItem = !this.hasGhostItem(slot) || this.getGhostItem(slot).m_41720_() == stack.m_41720_();
        return !stack.m_204117_(ModTags.BLACKLISTED_STORAGE) && checkGhostItem && super.isItemValid(slot, stack);
    }

    @Override
    public MinecraftServer getServer() {
        return this.server;
    }

    @Override
    public void setServer(MinecraftServer server) {
        this.server = server;
    }

    @Override
    public void setChangedDank() {
        this.onContentsChanged(0);
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.saveToDisk();
    }

    public int m_6413_(int slot) {
        return switch (slot) {
            case 0 -> this.frequency;
            case 1 -> this.textColor;
            case 2 -> {
                if (this.frequencyLocked) {
                    yield 1;
                }
                yield 0;
            }
            default -> -999;
        };
    }

    public void m_8050_(int slot, int value) {
        switch (slot) {
            case 0: {
                this.frequency = value;
                break;
            }
            case 1: {
                this.textColor = value;
                break;
            }
            case 2: {
                this.frequencyLocked = value == 1;
            }
        }
        this.onContentsChanged(slot);
    }

    @Override
    public int getMaxStackSizeDank() {
        return this.getSlotLimit(0);
    }

    @Override
    public void setItemDank(int slot, ItemStack stack) {
        this.setStackInSlot(slot, stack);
    }

    @Override
    public ItemStack addItemDank(int slot, ItemStack stack) {
        return this.insertItem(slot, stack, false);
    }

    @Override
    public ItemStack getItemDank(int slot) {
        return this.getStackInSlot(slot);
    }

    @Override
    public NonNullList<ItemStack> getGhostItems() {
        return this.ghostItems;
    }
}

