/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.network.server;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import tfar.dankstorage.inventory.DankInterface;
import tfar.dankstorage.menu.AbstractDankMenu;
import tfar.dankstorage.network.DankPacketHandler;
import tfar.dankstorage.network.util.C2SPacketHelper;
import tfar.dankstorage.utils.ButtonAction;
import tfar.dankstorage.utils.CommonUtils;

public class C2SButtonPacket
implements C2SPacketHelper {
    private final ButtonAction buttonAction;

    public C2SButtonPacket(ButtonAction buttonAction) {
        this.buttonAction = buttonAction;
    }

    public C2SButtonPacket(FriendlyByteBuf buf) {
        this.buttonAction = ButtonAction.values()[buf.readInt()];
    }

    public static void send(ButtonAction buttonAction) {
        DankPacketHandler.sendToServer(new C2SButtonPacket(buttonAction));
    }

    @Override
    public void handleServer(ServerPlayer player) {
        AbstractContainerMenu container = player.f_36096_;
        if (this.buttonAction.requiresContainer) {
            if (container instanceof AbstractDankMenu) {
                AbstractDankMenu dankContainer = (AbstractDankMenu)container;
                DankInterface inventory = dankContainer.dankInventory;
                switch (this.buttonAction) {
                    case LOCK_FREQUENCY: {
                        inventory.toggleFrequencyLock();
                        break;
                    }
                    case SORT: {
                        inventory.sort();
                        break;
                    }
                    case COMPRESS: {
                        inventory.compress(player);
                    }
                }
            }
        } else {
            switch (this.buttonAction) {
                case TOGGLE_TAG: {
                    CommonUtils.toggleTagMode(player);
                    break;
                }
                case TOGGLE_PICKUP: {
                    CommonUtils.togglePickupMode(player);
                    break;
                }
                case TOGGLE_USE_TYPE: {
                    CommonUtils.toggleUseType(player);
                }
            }
        }
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.buttonAction.ordinal());
    }
}

