/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.heat.heater;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.antarcticgardens.newage.NewAgeBlockEntityTypes;
import org.antarcticgardens.newage.config.NewAgeConfig;
import org.antarcticgardens.newage.content.heat.HeatBlockEntity;
import org.antarcticgardens.newage.content.heat.heater.HeaterBlockEntity;
import org.antarcticgardens.newage.content.heat.heatpipe.HeatPipeBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeaterBlock
extends Block
implements EntityBlock,
IWrenchable {
    public static final EnumProperty<BlazeBurnerBlock.HeatLevel> STRENGTH = BlazeBurnerBlock.HEAT_LEVEL;

    public HeaterBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60953_(state -> ((BlazeBurnerBlock.HeatLevel)state.m_61143_(STRENGTH)).ordinal()));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{STRENGTH});
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return NewAgeBlockEntityTypes.HEATER.create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        int on = HeatPipeBlock.massPipe++;
        if (HeatPipeBlock.massPipe >= 20) {
            HeatPipeBlock.massPipe = 0;
        }
        return (world, blockPos, blockState, sel) -> {
            HeaterBlockEntity self;
            if ((world.m_46467_() + (long)on) % 20L != 0L || !(sel instanceof HeaterBlockEntity) || (self = (HeaterBlockEntity)sel).m_58904_() == null) {
                return;
            }
            HeatBlockEntity.transferAround(self);
            Double mult = (Double)NewAgeConfig.getCommon().heaterRequiredHeatMultiplier.get();
            HeatBlockEntity.handleOverheat(self);
            if ((double)self.heat > 500.0 * mult) {
                self.heat -= (float)(500.0 * mult);
                level.m_7731_(blockPos, (BlockState)state.m_61124_(STRENGTH, (Comparable)BlazeBurnerBlock.HeatLevel.SEETHING), 3);
            } else if ((double)self.heat > 400.0 * mult) {
                self.heat -= (float)(400.0 * mult);
                level.m_7731_(blockPos, (BlockState)state.m_61124_(STRENGTH, (Comparable)BlazeBurnerBlock.HeatLevel.KINDLED), 3);
            } else if ((double)self.heat > 100.0 * mult) {
                self.heat -= (float)(100.0 * mult);
                level.m_7731_(blockPos, (BlockState)state.m_61124_(STRENGTH, (Comparable)BlazeBurnerBlock.HeatLevel.FADING), 3);
            } else if ((double)self.heat > 50.0 * mult) {
                self.heat -= (float)(50.0 * mult);
                level.m_7731_(blockPos, (BlockState)state.m_61124_(STRENGTH, (Comparable)BlazeBurnerBlock.HeatLevel.SMOULDERING), 3);
            } else {
                level.m_7731_(blockPos, (BlockState)state.m_61124_(STRENGTH, (Comparable)BlazeBurnerBlock.HeatLevel.NONE), 3);
            }
            self.m_6596_();
        };
    }
}

